#![allow(unknown_lints)]
#![allow(clippy::all)]
#![allow(
    missing_debug_implementations,
    missing_copy_implementations,
    trivial_casts,
    trivial_numeric_casts,
    unsafe_code,
    unstable_features,
    unused_import_braces,
    unused_qualifications,
    unused_imports
)]
// This code was autogenerated with `dbus-codegen-rust -m None -c ffidisp`, see https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::ffidisp;

pub trait OrgMprisMediaPlayer2 {
    fn raise(&self) -> Result<(), dbus::Error>;
    fn quit(&self) -> Result<(), dbus::Error>;
    fn can_quit(&self) -> Result<bool, dbus::Error>;
    fn fullscreen(&self) -> Result<bool, dbus::Error>;
    fn set_fullscreen(&self, value: bool) -> Result<(), dbus::Error>;
    fn can_set_fullscreen(&self) -> Result<bool, dbus::Error>;
    fn can_raise(&self) -> Result<bool, dbus::Error>;
    fn has_track_list(&self) -> Result<bool, dbus::Error>;
    fn identity(&self) -> Result<String, dbus::Error>;
    fn desktop_entry(&self) -> Result<String, dbus::Error>;
    fn supported_uri_schemes(&self) -> Result<Vec<String>, dbus::Error>;
    fn supported_mime_types(&self) -> Result<Vec<String>, dbus::Error>;
}

impl<'a, C: ::std::ops::Deref<Target = ffidisp::Connection>> OrgMprisMediaPlayer2
    for ffidisp::ConnPath<'a, C>
{
    fn raise(&self) -> Result<(), dbus::Error> {
        self.method_call("org.mpris.MediaPlayer2", "Raise", ())
    }

    fn quit(&self) -> Result<(), dbus::Error> {
        self.method_call("org.mpris.MediaPlayer2", "Quit", ())
    }

    fn can_quit(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "CanQuit",
        )
    }

    fn fullscreen(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "Fullscreen",
        )
    }

    fn can_set_fullscreen(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "CanSetFullscreen",
        )
    }

    fn can_raise(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "CanRaise",
        )
    }

    fn has_track_list(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "HasTrackList",
        )
    }

    fn identity(&self) -> Result<String, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "Identity",
        )
    }

    fn desktop_entry(&self) -> Result<String, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "DesktopEntry",
        )
    }

    fn supported_uri_schemes(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "SupportedUriSchemes",
        )
    }

    fn supported_mime_types(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2",
            "SupportedMimeTypes",
        )
    }

    fn set_fullscreen(&self, value: bool) -> Result<(), dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.mpris.MediaPlayer2",
            "Fullscreen",
            value,
        )
    }
}
