% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{graph.incidence}
\alias{graph.incidence}
\title{Create graphs from a bipartite adjacency matrix}
\usage{
graph.incidence(
  incidence,
  directed = FALSE,
  mode = c("all", "out", "in", "total"),
  multiple = FALSE,
  weighted = NULL,
  add.names = NULL
)
}
\arguments{
\item{incidence}{The input bipartite adjacency matrix. It can also be a sparse matrix
from the \code{Matrix} package.}

\item{directed}{Logical scalar, whether to create a directed graph.}

\item{mode}{A character constant, defines the direction of the edges in
directed graphs, ignored for undirected graphs. If \sQuote{\code{out}}, then
edges go from vertices of the first kind (corresponding to rows in the
bipartite adjacency matrix) to vertices of the second kind (columns in the incidence
matrix). If \sQuote{\verb{in}}, then the opposite direction is used. If
\sQuote{\code{all}} or \sQuote{\code{total}}, then mutual edges are created.}

\item{multiple}{Logical scalar, specifies how to interpret the matrix
elements. See details below.}

\item{weighted}{This argument specifies whether to create a weighted graph
from the bipartite adjacency matrix. If it is \code{NULL} then an unweighted graph is
created and the \code{multiple} argument is used to determine the edges of
the graph. If it is a character constant then for every non-zero matrix
entry an edge is created and the value of the entry is added as an edge
attribute named by the \code{weighted} argument. If it is \code{TRUE} then a
weighted graph is created and the name of the edge attribute will be
\sQuote{\code{weight}}.}

\item{add.names}{A character constant, \code{NA} or \code{NULL}.
\code{graph_from_biadjacency_matrix()} can add the row and column names of the incidence
matrix as vertex attributes. If this argument is \code{NULL} (the default)
and the bipartite adjacency matrix has both row and column names, then these are added
as the \sQuote{\code{name}} vertex attribute. If you want a different vertex
attribute for this, then give the name of the attributes as a character
string. If this argument is \code{NA}, then no vertex attributes (other than
type) will be added.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph.incidence()} was renamed to \code{\link[=graph_from_biadjacency_matrix]{graph_from_biadjacency_matrix()}} to create a more
consistent API.
}
\keyword{internal}
