DESC="Generate dependencies and compile source code"

runtest()
{
  mkdir -p dep obj

  OBJ="obj/Test.o"
  DepFile="dep/Test.d"


  EXEC="${AGCC} --path ${TestSrcDir} -v2  -MF ${DepFile} -MD -c ${TestSrcDir}/Test.cc -o ${OBJ}"
  
  echo "Executing '${EXEC}'"
  if  ( ${EXEC} );then true;else
    ERR_MSG="Failed executing  '${EXEC}'"
    return 1
  fi

  if [ ! -f ${DepFile} ];then
    ERR_MSG="File '${DepFile}' with dependency information was not generated"
    return 1
  fi

  if [ ! -f ${OBJ} ];then
    ERR_MSG="Object file '${OBJ}' was not created"
    return 1
  fi

  DepRefFile="dep/Test.ref.d"
  g++ -include ${TestSrcDir}/trace.ah -M -MF ${DepRefFile}  ${TestSrcDir}/Test.cc

  echo -e "\nDIFF BETWEEN FILES '${DepRefFile}' and '${DepFile}': \n"
  if ( diff ${DepRefFile} ${DepFile} );then
    echo  " none"
    return 0
  else
    ERR_MSG="Dependency information differs between 'g++' and 'ag++' (files: '${DepRefFile}' and '${DepFile}')"
    return 1
  fi
}


