#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Dream Machine
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241218.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='the-dream-machine'
GAME_NAME='The Dream Machine'

ARCHIVE_BASE_1_NAME='setup_the_dream_machine_1.0.6_(52258).exe'
ARCHIVE_BASE_1_MD5='74df25d3c3f2669c8b95db87a0f00a11'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1117856'
ARCHIVE_BASE_1_VERSION='1.0.6-gog52258'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_dream_machine'

ARCHIVE_BASE_0_NAME='setup_the_dream_machine_1.0.2_(38172).exe'
ARCHIVE_BASE_0_MD5='7b2bdaf4bcddfaafeea2e8d2ed66f21a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='1.0.2-gog38172'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
the_dream_machine.exe'
CONTENT_GAME_DATA_FILES='
assets
gameassets.swf
gameasset_floors.swf
gameasset_fonts.swf
gameasset_sounds.swf
launcher.txt
tdm*'

USER_PERSISTENT_DIRECTORIES='
savegames'

APP_MAIN_EXE='the_dream_machine.exe'
APP_MAIN_ICON='app/goggame-1281766827.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
