/*
 * This source file is part of libRocket, the HTML/CSS Interface Middleware
 *
 * For the latest information, see http://www.librocket.com
 *
 * Copyright (c) 2008-2010 CodePoint Ltd, Shift Technology Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#include "precompiled.h"

namespace Rocket {
namespace Core {

const String MARGIN_TOP = "margin-top";
const String MARGIN_RIGHT = "margin-right";
const String MARGIN_BOTTOM = "margin-bottom";
const String MARGIN_LEFT = "margin-left";
const String MARGIN = "margin";
const String PADDING_TOP = "padding-top";
const String PADDING_RIGHT = "padding-right";
const String PADDING_BOTTOM = "padding-bottom";
const String PADDING_LEFT = "padding-left";
const String PADDING = "padding";
const String BORDER_TOP_WIDTH = "border-top-width";
const String BORDER_RIGHT_WIDTH = "border-right-width";
const String BORDER_BOTTOM_WIDTH = "border-bottom-width";
const String BORDER_LEFT_WIDTH = "border-left-width";
const String BORDER_WIDTH = "border-width";
const String BORDER_TOP_COLOR = "border-top-color";
const String BORDER_RIGHT_COLOR = "border-right-color";
const String BORDER_BOTTOM_COLOR = "border-bottom-color";
const String BORDER_LEFT_COLOR = "border-left-color";
const String BORDER_COLOR = "border-color";
const String BORDER_TOP = "border-top";
const String BORDER_RIGHT = "border-right";
const String BORDER_BOTTOM = "border-bottom";
const String BORDER_LEFT = "border-left";
const String DISPLAY = "display";
const String POSITION = "position";
const String TOP = "top";
const String RIGHT = "right";
const String BOTTOM = "bottom";
const String LEFT = "left";
const String FLOAT = "float";
const String CLEAR = "clear";
const String Z_INDEX = "z-index";
const String WIDTH = "width";
const String MIN_WIDTH = "min-width";
const String MAX_WIDTH = "max-width";
const String HEIGHT = "height";
const String MIN_HEIGHT = "min-height";
const String MAX_HEIGHT = "max-height";
const String LINE_HEIGHT = "line-height";
const String VERTICAL_ALIGN = "vertical-align";
const String OVERFLOW_X = "overflow-x";
const String OVERFLOW_Y = "overflow-y";
const String CLIP = "clip";
const String VISIBILITY = "visibility";
const String BACKGROUND_COLOR = "background-color";
const String BACKGROUND = "background";
const String COLOR = "color";
const String FONT_FAMILY = "font-family";
const String FONT_CHARSET = "font-charset";
const String FONT_STYLE = "font-style";
const String FONT_WEIGHT = "font-weight";
const String FONT_SIZE = "font-size";
const String FONT = "font";
const String TEXT_ALIGN = "text-align";
const String TEXT_DECORATION = "text-decoration";
const String TEXT_TRANSFORM = "text-transform";
const String WHITE_SPACE = "white-space";
const String CURSOR = "cursor";
const String DRAG = "drag";
const String TAB_INDEX = "tab-index";
const String SCROLLBAR_MARGIN = "scrollbar-margin";
const String SCROLL_DEFAULT_STEP_SIZE = "scroll-default-step-size";

const String MOUSEDOWN = "mousedown";
const String MOUSESCROLL = "mousescroll";
const String MOUSEOVER = "mouseover";
const String MOUSEOUT = "mouseout";
const String FOCUS = "focus";
const String BLUR = "blur";
const String KEYDOWN = "keydown";
const String MOUSEUP = "mouseup";
const String CLICK = "click";
const String DRAGSTART = "dragstart";
const String DRAGOVER = "dragover";
const String LOAD = "load";
const String UNLOAD = "unload";
const String KEYUP = "keyup";
const String TEXTINPUT = "textinput";
const String MOUSEMOVE = "mousemove";
const String DRAGMOVE = "dragmove";
const String DBLCLICK = "dblclick";
const String DRAGDROP = "dragdrop";
const String DRAGOUT = "dragout";
const String DRAGEND = "dragend";
const String RESIZE = "resize";

}
}
