#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
   {TR_NO_PATCH_TITLE, "Atualização 1.0.1.0 não instalada"},
    {TR_NO_PATCH_MESSAGE,
        "Sua versão de Caesar III não tem a atualização 1.0.1.0 instalada. "
        "Você pode baixar a atualização em:\n"
        URL_PATCHES "\n"
        "Continue por seu próprio risco."},
    {TR_MISSING_FONTS_TITLE, "Fontes faltando"},
    {TR_MISSING_FONTS_MESSAGE,
        "Sua instalação de Caesar III precisa de outros arquivos de fontes. "
        "Você pode baixá-las para seu idioma em:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor não instalado"},
    {TR_NO_EDITOR_MESSAGE,
        "Sua versão de Caesar III não possui os arquivos do Editor de Mapas. "
        "Você pode baixá-lo em:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Pasta de idioma inválida"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "A pasta selecionada não contém um pacote de idioma válido. "
        "Verifique o arquivo de registro para ver os erros"},
    {TR_AUTO_CYCLE_TEMPLES, "Tudo"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Cancelar"},
    {TR_BUTTON_RESET_DEFAULTS, "Redefinir padrões"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Configurar atalhos"},
    {TR_CONFIG_ARE_YOU_SURE, "Reset to defaults?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Suas configurações personalizadas serão apagadas."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Seus atalhos personalizados serão apagados."},
    {TR_CONFIG_TITLE, "Opções de Configurações do Augustus"},
    {TR_CONFIG_HEADER_GENERAL, "Configurações Gerais"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Interface de Usuário"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Dificuldade"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Administração da Cidade"},
    {TR_CONFIG_LANGUAGE_LABEL, "Idioma:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(padrão)"},
    {TR_CONFIG_GAME_SPEED, "Velocidade de Jogo:"},
    {TR_CONFIG_VIDEO, "Opções de Vídeo"},
    {TR_CONFIG_FULLSCREEN, "Tela Cheia"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Resoluções do modo janela:"},
    {TR_CONFIG_DISPLAY_SCALE, "Escala de exibição:"},
    {TR_CONFIG_CURSOR_SCALE, "Escala do cursor:"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Usar cursores coloridos"},
    {TR_CONFIG_AUDIO, "Opções de Áudio"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Ativar áudio"},
    {TR_CONFIG_MUSIC, "Ativar núsica"},
    {TR_CONFIG_SPEECH, "Ativar falas"},
    {TR_CONFIG_EFFECTS, "Ativar efeitos sonoros"},
    {TR_CONFIG_CITY_SOUNDS, "Ativar sons da cidade"},
    {TR_CONFIG_SCROLL_SPEED, "Velocidade de rolagem:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Tocar vídeos de abertura"},
    {TR_CONFIG_SIDEBAR_INFO, "Informação extra no painel de controle"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Ativar rolagem suave"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Desativar rolagem do mapa no limite da tela"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Desativar rolagem do mapa com botão direito do mouse"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Ativar indicador visual ao limpar o terreno"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Permitir construir cada templo em sequência"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Mostrar alcance ao construir reservatórios, fontes e poços"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Mostrar o tamanho da construção ao arrastar"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Realçar legiões focadas pelo mouse"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotacionar Portões e Arcos do Triunfo por atalhos"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Mostrar barra lateral militar"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Desativar rolagem do mapa com botão direito do mouse"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Consertar falha durante a imigração na dificuldade máxima"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Consertar falha dos 'fantasmas' de 100 anos"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Consertar troca de Imperador e tempo de sobrevivência em missões personalizadas"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Conserta as colunas de índices incompletas em objetivos de índices baixos"},
    {TR_CONFIG_GRANDFESTIVAL, "Festivais Suntuosos permitem bênçãos extras do deus"},
    {TR_CONFIG_DIFFICULTY, "Dificuldade:"},
    {TR_CONFIG_GODS_EFFECTS, "Ativar bençãos/pragas dos deuses"},
    {TR_CONFIG_JEALOUS_GODS, "Desativar ciúmes dos deuses"},
    {TR_CONFIG_GLOBAL_LABOUR, "Ativar força de trabalho universal"},
    {TR_CONFIG_SCHOOL_WALKERS, "Estender alcance dos estudantes das escolas"},
    {TR_CONFIG_RETIRE_AT_60, "Aumentar a idade de aposentadoria de 50 para 60 anos"},
    {TR_CONFIG_FIXED_WORKERS, "Força de trabalho fixa - 38% da população plebeia"},
    {TR_CONFIG_EXTRA_FORTS, "Permitir construir 4 fortes adicionais"},
    {TR_CONFIG_WOLVES_BLOCK, "Impedir construção em volta de lobos"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloquear estradas de celeiro não conectadas"},
    {TR_CONFIG_MORE_STOCKPILE, "Moradias estocam mais mercadorias"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Funcionárias do mercado não distribuem mercadorias quando estiverem comprando"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Destrói construções imediatamente"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Carroceiros de celeiros com ordem de busca podem sair da estrada"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Duplicar a capacidade de carroceiros de celeiros com ordem de busca"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Permitir que mercadores exportem comida diretamente dos celeiros"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Sentinelas de torres não precisam de acesso ao quartel por estrada"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Fazendas e pesqueiros entregam apenas para os celeiros mais próximos"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Não entregar comida para celeiros com ordem de busca"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Todas as moradias se fundem"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Rota comercial aberta conta como fornecendo um tipo adicional de vinho"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Durante evento de desabamento aleatório, minas gastam dinheiro ao invés de desabar"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Permitir a construção de vários quartéis" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Armazéns e celeiros são programados para não aceitarem nada ao construídos"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Moradias não se expandem sobre jardins"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Andarilhos não pulam esquinas"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Mostrar o índice máximo de prosperidade possível com o nível atual de moradias"},
    {TR_HOTKEY_TITLE, "Configurações de teclas de atalho do Augustus"},
    {TR_HOTKEY_LABEL, "Tecla de atalho"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativa"},
    {TR_HOTKEY_HEADER_ARROWS, "Teclas de seta"},
    {TR_HOTKEY_HEADER_GLOBAL, "Atalhos gerais"},
    {TR_HOTKEY_HEADER_CITY, "Atalhos da cidade"},
    {TR_HOTKEY_HEADER_ADVISORS, "Conselheiros"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Mapa específicos"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Pontos de referência"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Atalhos de construção"},
    {TR_HOTKEY_ARROW_UP, "Cima"},
    {TR_HOTKEY_ARROW_DOWN, "Baixo"},
    {TR_HOTKEY_ARROW_LEFT, "Esquerda"},
    {TR_HOTKEY_ARROW_RIGHT, "Direita"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Tela Cheia"},
    {TR_HOTKEY_CENTER_WINDOW, "Centralizar"},
    {TR_HOTKEY_RESIZE_TO_640, "Redimensionar para 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Redimensionar para 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Redimensionar para 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Capturar tela"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Capturar imagem de cidade"},
    {TR_HOTKEY_BUILD_CLONE, "Clonar construção sob o cursor"},
    {TR_HOTKEY_LOAD_FILE, "Carregar jogo"},
    {TR_HOTKEY_SAVE_FILE, "Salvar jogo"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Aumentar velocidade do jogo"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Reduzir velocidade do jogo"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Dar pausa"},
    {TR_HOTKEY_CYCLE_LEGION, "Circular por legiões"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Girar no sentido anti-horário"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Girar no sentido horário"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Trabalho"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Militar"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperial"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Índices"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Comércio Exterior"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "População"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Saúde"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Educação"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Entretenimento"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religião"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finanças"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Conselheiro Chefe"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Moradias"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Alternar Mapa Atual/Padrão"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Mostrar Mapa Relativo"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Mapa de Água"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Mapa de Fogo"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Mapa de Avarias"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Mapa de Criminalidade"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotacionar construções"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Mapa de Problemas"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Ir para marcador 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Ir para marcador 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Ir para marcador 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Ir para marcador 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Definir marcador 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Definir marcador 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Definir marcador 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Definir marcador 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Mostrar informações de batalha"},
    {TR_HOTKEY_EDIT_TITLE, "Nova tecla de atalho"},
    { TR_BUILDING_ROADBLOCK, "Bloqueio de Estrada" },
    { TR_BUILDING_ROADBLOCK_DESC, "Bloqueio de estrada - impede cidadãos ociosos." },
    { TR_BUILDING_ARCHITECT_GUILD, "Guilda de Arquitetura" },
    { TR_BUILDING_ARCHITECT_GUILD_DESC, "Os arquitetos trabalham incansavelmente, construindo monumentos pela glória de Roma." },
    { TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Designa um epíteto no templo" },
    { TR_BUILDING_GRAND_TEMPLE_CERES, "Santuário de Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Santuário de Netuno" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY, "Santuário de Mercúrio" },
    { TR_BUILDING_GRAND_TEMPLE_MARS, "Santuário de Marte" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS, "Santuário de Vênus" },
    { TR_BUILDING_PANTHEON, "Panteão" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Santuário de Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Santuário de Netuno" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Santuário de Mercúrio" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Santuário de Marte" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Santuário de Vênus" },
    { TR_BUILDING_PANTHEON_DESC, "Panteão" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Carroceiros de fazendas se movem 50% mais rápido." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Fontes e reservatórios precisam de menos trabalhadores e têm alcance maior. Navios mercantes se movem 25% mais rápido." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Caravanas e navios mercantes têm capacidade 50% maior. Caravanas se movem 25% mais rápido." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Treina soldados como se fosse um quartel. Permite a construção de quatro fortes adicionais." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Jardins, estátuas e templos reluzem com ainda mais beleza, aumentando a atratividade. Moradias armazenam mais bens e regridem mais devagar." },
    { TR_BUILDING_PANTHEON_BONUS_DESC, "Provê acesso a todos os deuses. Realiza festivais anuais e reduz o custo de manutenção dos templos em 25%." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Sacerdotes reduzem o cunsumo de comida em 20%." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Templos enviam condutores de biga para o hipódromo." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Sacerdotes reduzem o consumo de cerâmica e de móveis em 20%." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Templos produzem comida em quantidade proporcional ao número de moradias que cobrem e a entregam ao posto de suprimentos." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "O Santuário produz vinho em quantidade proporcional à população com acesso a templos de Vênus. Templos recolhem e distribuem vinho para as moradias." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Sacerdotes recolhem e distribuem azeite e uma variedade de comida dos estoques da cidade." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Sacerdotes aumentam em 5% a capacidade das moradias. O Santuário provêm abastecimento de água como se fosse um reservatório cheio." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Sacerdotes reduzem em 20% o consumo de vinho e de azeite." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Sacerdotes reduzem em 10% o consumo de todos os bens." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Sacerdotes provêm entretenimento e embelezam as moradias." },
    { TR_BUILDING_PANTHEON_MODULE_1_DESC, "Todos os templos da cidade enviam sacerdotes ao Panteão, aumentando a fé e as bênçãos de seus deuses." },
    { TR_BUILDING_PANTHEON_MODULE_2_DESC, "Moradias com acesso ao Panteão conseguem evoluir um nível a mais." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Templo de Ceres Promitor" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Templo de Ceres Reparator" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Templo de Neptunus Equester" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Templo de Neptunus Adiutor" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Templo de Mercurius Fortunus" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Templo de Mercurius Abundantia" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Templo de Mars Ultor" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Templo de Mars Quirinus" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Templo de Venus Verticordia" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Templo de Venus Genetrix" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    { TR_BUILDING_GRAND_TEMPLE_MENU, "Santuário" },
    { TR_BUILDING_WORK_CAMP, "Campo de trabalho" },
    { TR_BUILDING_WORK_CAMP_DESC, "Trabalhadores se reúnem aqui para transportar material de construção aos canteiros de obras." },
    { TR_HEADER_HOUSING, "Habitação" },
    { TR_ADVISOR_HOUSING_ROOM, "Moradias da cidade têm espaço para mais" },
    { TR_ADVISOR_HOUSING_NO_ROOM, "Não há mais espaço nas moradias da cidade." },
    { TR_ADVISOR_RESIDENCES_USING_POTTERY, "Moradias precisando de cerâmica" },
    { TR_ADVISOR_RESIDENCES_USING_FURNITURE, "Moradias precisando de móveis" },
    { TR_ADVISOR_RESIDENCES_USING_OIL, "Moradias precisando de azeite" },
    { TR_ADVISOR_RESIDENCES_USING_WINE, "Moradias precisando de vinho" },
    { TR_ADVISOR_TOTAL_NUM_HOUSES, "Total de moradias:" },
    { TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacidade disponível:" },
    { TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacidade total:" },
    { TR_ADVISOR_ADVISOR_HEADER_HOUSING, "População - Habitação" },
    { TR_ADVISOR_BUTTON_GRAPHS, "Gráficos" },
    { TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Índice de prosperidade de moradias: " },
    { TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Porcentagem de população em villas e palácios: " },
    { TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Porcentagem de população em barracas e choupanas: " },
    { TR_ADVISOR_AVERAGE_TAX, "Arrecadação média de impostos por moradia: " },
    { TR_ADVISOR_AVERAGE_AGE, "Idade média da população: " },
    { TR_ADVISOR_PERCENT_IN_WORKFORCE, "Porcentagem de população economicamente ativa: " },
    { TR_ADVISOR_BIRTHS_LAST_YEAR, "Nascimentos no ano passado:" },
    { TR_ADVISOR_DEATHS_LAST_YEAR, "Óbitos no ano passado:" },
    { TR_ADVISOR_TOTAL_POPULATION, "Total de residentes" },
    {TR_ADVISOR_IN_STORAGE, "em estoque"},
    {TR_ADVISOR_FROM_GRANARIES, "de celeiros"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Enviando comida de celeiros"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Tem certeza?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Continuar estocando recursos"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "A prosperidade máxima para o nível atual de moradias é"},
    { TR_REQUIRED_RESOURCES, "Materiais entregues para a fase atual:" },
    { TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "A construção do Santuário requer materiais estocados em um armazém, trabalhadores de um campo de trabalho e arquitetos de uma guilda de arquitetura." },
    { TR_CONSTRUCTION_PHASE, "Fase da construção:" },
    { TR_ADD_MODULE, "Rededicar templo?" },
    { TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epíteto outorgado." },
    { TR_BUILDING_CERES_TEMPLE_QUOTE, "Primeira foi Ceres o chão com o arado sulcar\nPrimeira à terra grãos e moles frutos dar\nE primeira aos homens a justa lei outorgar\nTudo é um dom de Ceres!\n-Ovídio, Metamorfoses" },
    { TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Nem a ira do mar resta, quando Netuno o tridente abaixa\nacalma as ondas o senhor do pélago.\nE Tritão, cerúleo, flutua à superfície;\nombro envolto em púrpura, o búzio sopra;\ne as vagas e rios ele assim ordena.\n-Ovídio, Metamorfoses" },
    { TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Bois e robustas ovelhas são passíveis de pilhagem,\ntrípodes e castanhas cabeças de cavalos, de aquisição.\nMas a alma de um homem não mais volta \nnem por pilhagem nem por escambo \numa vez perdida por entre seus dentes\n-Homero, Ilíada" },
    { TR_BUILDING_MARS_TEMPLE_QUOTE, "A serviço de Marte forjaram rodas aladas,\nCom que o senhor da guerra exalta\n aos homens e cidades,\nAo som terrível de espanto e raiva.\n-Virgílio, Eneida" },
    { TR_BUILDING_VENUS_TEMPLE_QUOTE, "Ó Vênus, e tu, alado Cupido, ao lado de tua terna mãe,\nQuanto me deleitei!\nQuão real o prazer que alcancei!\nComo no leito senti meu coração derreter!\n-Ovídio, Metamorfoses" },
    { TR_BUILDING_PANTHEON_QUOTE, "Os portões do Olimpo se abrem ao chamar de Júpiter\nPela reunião de seu conselho no céu dos astros\nSeus lugares tomam os deuses numa grande sala\nE lá dos altos se pode olhar a terra inteira.\n-Virgílio, Eneida" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Pódio)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Pórtico)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cela)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Precinto)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicação)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Os trabalhadores estão construindo um pódio para elevar o templo e garantir uma fundação sólida que resita à passagem do tempo." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Os artesão estão esculpindo o pórtico, onde ficará o altar de sacrifícios." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Os engenheiros estão construindo a cela, o interior do templo, que abrigará as imagens sagradas." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Os trabalhos no precinto já começaram; este será o local onde os fiéis se reunirão para cerimônias públicas ao ar livre." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Com o Santuário quase completo, os sacerdotes se reúnem para realizar os ritos de consagração." },
    { TR_BUILDING_MENU_TREES, "Árvores" },
    { TR_BUILDING_MENU_PATHS, "Caminhos" },
    { TR_BUILDING_MENU_PARKS, "Parques" },
    { TR_BUILDING_SMALL_POND, "Laguinho" },
    { TR_BUILDING_LARGE_POND, "Lago" },
    { TR_BUILDING_PINE_TREE, "Pinheiro" },
    { TR_BUILDING_FIR_TREE, "Abeto" },
    { TR_BUILDING_OAK_TREE, "Carvalho" },
    { TR_BUILDING_ELM_TREE, "Olmo" },
    { TR_BUILDING_FIG_TREE, "Figueira" },
    { TR_BUILDING_PLUM_TREE, "Ameixeira" },
    { TR_BUILDING_PALM_TREE, "Palmeira" },
    { TR_BUILDING_DATE_TREE, "Tamareira" },
    { TR_BUILDING_PINE_PATH, "Caminho de pinheiros" },
    { TR_BUILDING_FIR_PATH, "Caminho de abetos" },
    { TR_BUILDING_OAK_PATH, "Caminho de carvalhos" },
    { TR_BUILDING_ELM_PATH, "Caminho de olmos" },
    { TR_BUILDING_FIG_PATH, "Caminho de figueiras" },
    { TR_BUILDING_PLUM_PATH, "Caminho de ameixeiras" },
    { TR_BUILDING_PALM_PATH, "Caminho de palmeiras" },
    { TR_BUILDING_DATE_PATH, "Caminho de tamareiras" },
    { TR_BUILDING_BLUE_PAVILION, "Coreto azul" },
    { TR_BUILDING_RED_PAVILION, "Coreto vermelho" },
    { TR_BUILDING_ORANGE_PAVILION, "Coreto laranja" },
    { TR_BUILDING_YELLOW_PAVILION, "Coreto amarelo" },
    { TR_BUILDING_GREEN_PAVILION, "Coreto verde" },
    { TR_BUILDING_SMALL_STATUE_ALT, "Estátua de deusa" },
    { TR_BUILDING_SMALL_STATUE_ALT_B, "Estátua de senador" },
    { TR_BUILDING_OBELISK, "Obelisco" },
    { TR_BUILDING_POND_DESC, "Lagos são abastecidos pelos reservatórios da cidade e provêm água para plantas e animais, além de serem um oásis refrescante e relaxante para a população. Os cidadãos adoram viver perto de um lago." },
    { TR_BUILDING_WINDOW_POND, "Lago" },
    { TR_BUILDING_OBELISK_DESC, "Um monumento imponente, erguido por um antigo rei do Nilo. Os egípcios não estavam usando..." },
    { TR_ADVISOR_FINANCE_LEVIES, "Custos de manutenção" },
    { TR_CONFIRM_DELETE_MONUMENT, "Demolindo este monumento" },
    { TR_SELECT_EPITHET_PROMPT_HEADER, "Selecione um epíteto" },
    { TR_SELECT_EPITHET_PROMPT_TEXT, "Outorgar um epíteto dedica permanentemente o Santuário a um aspecto da divindade, dando poderes divinos aos seus sacerdotes." },
    { TR_BUILDING_INFO_MONTHLY_LEVY, "/mês" },
    { TR_BUILDING_MESS_HALL, "Posto de suprimentos" },
    { TR_BUILDING_MESS_HALL_DESC, "O posto de suprimentos recolhe comida dos celeiros da cidade para abastecer os soldados nos fortes. Um posto mal abastecido atrasa o recrutamento e prejudica o moral das tropas." },
    { TR_BUILDING_MESS_HALL_FULFILLMENT, "Abastecimento de comida no mês passado:" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Os soldados estão: " },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Bem alimentados" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Alimentados" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Com fome" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Com muita fome" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Morrendo de fome" },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "A dieta variada dos soldados aumenta bastante o moral." },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "A dieta diversificada e nutritiva dos soldados aumenta enormemente o moral." },
    { TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Não há soldados para alimentar." },
    { TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Meses de comida estocada:" },
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instruções do posto de suprimentos"},
    { TR_BUILDING_BARRACKS_FOOD_WARNING, "A falta de comida nos postos de suprimentos está retardando o recrutamento de soldados." },
    { TR_BUILDING_BARRACKS_FOOD_WARNING_2, "O grave desabastecimento dos postos de suprimentos está impedindo o recrutamento de soldados." },
    { TR_BUILDING_LEGION_FOOD_WARNING_1, "Recente falta de comida diminuiu o moral" },
    { TR_BUILDING_LEGION_FOOD_WARNING_2, "Recente falta de comida diminuiu bastante o moral" },
    { TR_BUILDING_LEGION_STARVING, "Falta de comida" },
    { TR_ADVISOR_TRADE_MAX, "Máx" },
    { TR_ADVISOR_TRADE_NO_LIMIT, "Sem limite" },
    { TR_ADVISOR_TRADE_IMPORTABLE, "Importável" },
    { TR_ADVISOR_TRADE_EXPORTABLE, "Exportável" },
    {TR_ADVISOR_TRADE_NO_BUYERS, "Não há compradores para este recurso"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Não há fornecedores para este recurso"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Não importando"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Não exportando"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Abre rota comercial para importar"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Abre rota comercial para exportar"},
    { TR_ADVISOR_LEGION_FOOD_SATISFIED, "Os soldados têm toda a comida de que precisam." },
    { TR_ADVISOR_LEGION_FOOD_NEEDED, "Os soldados precisam de mais comida." },
    { TR_ADVISOR_LEGION_FOOD_CRITICAL, "Os soldados estão passando fome!" },
    { TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Meses de comida estocada no posto de suprimentos:" },
    { TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldados famintos" },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "O posto de suprimentos está com grave falta de comida, afetando negativamente o moral das tropas. Garanta que o posto de suprimentos consiga acessar um celeiro bem estocado." },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "A cidade perdeu seu posto de suprimentos e as tropas agora estão com fome. Construa um posto de suprimentos imediatamente." },
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Instruções"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instruções"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instruções"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instruções"},
    { TR_WARNING_NO_MESS_HALL, "Construa um posto de suprimentos primeiro, para alimentar os soldados." },
    { TR_WARNING_MAX_GRAND_TEMPLES, "Apenas dois Santuários podem ser construídos." },
    { TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Santuário completado" },
    { TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Sacerdotes e fiéis estão se reunindo no Santuário para os ritos de dedicação. O povo está estasiado diante da majestosidade de teus feitos, e a divindade escolhida te enche de graças." },
    { TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Uma bênção de Mercúrio" },
    { TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Encantado com a tua devoção, Mercúrio abençoa a tua indústria, revelando matérias-primas aos artesãos." },
    { TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Capataz" },
    { TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Carregador" },
    { TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Arquiteto" },
    { TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Contramestre" },
    { TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Servente" },
    { TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "O Santuário de Ceres mobiliza seus sacerdotes para a distribuição de comida e azeite aos cidadãos famintos." },
    { TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "O Santuário de Vênus permite que seus sacerdotes distribuam do vinho sagrado aos cidadãos." },
    { TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "O Santuário de Marte mobiliza seus sacerdotes para o abastecimento dos postos de suprimentos com comida." },
    { TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Templo de Ceres" },
    { TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Templo de Netuno" },
    { TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Templo de Mercúrio" },
    { TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Templo de Marte" },
    { TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Templo de Vênus" },
    { TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Sacerdote" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Cidades com rotas comerciais marítimas abertas:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Não há rotas comerciais marítimas abertas." },
    // Transcription of mission_exact4.wav
    { TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Vou fazer o que puder para acalmar esses bárbaros. Estou certo de que eles irão parar de atacar quando eu conseguir conversar com eles.\"" },
    { TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Um festival anual" },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Os fiéis lotam os templos para a celebração da Cerealia, em honra a Ceres. Os fazendeiros oferecem sacrifícios pedindo colheitas abundantes nos próximos anos." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Hoje celebramos o festival da Neptunalia, em honra a Netuno. Os fiéis constróem cabanas com galhos e folhas e celebram sob o cálido sol do verão." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Comerciantes e mercadores aparecem em massa para a celebração da Mercuralia. Navios e armazéns são untados com água benta para que sejam protegidos por Mercúrio." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Os cidadãos se reunem fora da cidade para a celebração da Equirria, em busca das graças de Marte. O ar se enche com o trovão dos cascos e o trepidar das bigas, enquanto os fiéis competem em corridas em homenagem ao deus." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Os fiéis se reúnem para a celebração da Veneralia, dia sagrado de Vênus. Os cidadãos buscam a deusa, rogando por boa sorte no amor." },
    { TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Apagar mensagens lidas" },
    { TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Fechar esse edifício" },
    { TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Abrir esse edifício" },
    { TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Permitir que compradoras do mercado comprem daqui" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Permitir que caravanas negociem aqui" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Permitir que navios mercantes negociem aqui" },
    { TR_BUILDING_LIGHTHOUSE, "Farol" },
    {TR_BUILDING_CARAVANSERAI, "Caravançará"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Caravanas mercantes param aqui para descansar e alimentar seus animais. Bloqueios de rotas terrestres duram metade do tempo."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instruções do caravançará"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fundação)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Os engenheiros lançam as fundações de um abrigo para mercadores."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Provedor do caravançará" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Coletor do caravançará" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Política comercial terrestre" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Sem política comercial terrestre." },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Seleciona uma política comercial terrestre para a cidade. Pode ser trocada por outra política a qualquer momento." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Política do vendedor terrestre: exportações terrestres ganham 20% a mais, mas importações são 10% mais caras." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Política do comprador terrestre: importações terrestres são 20% mais baratas, mas as exportações ganham 10% menos." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Política das capacidades terrestres: caravanas terrestres transportam 4 unidades adicionais de mercadorias, mas consomem 20% mais comida no Caravançará." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fundação)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Torre)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Coroa)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Os engenheiros estão construíndo uma fundação sólida para suportar o peso de uma grande torre de pedra." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Os pedreiros estão construíndo um pedestal para elevar a chama do farol além do horizonte." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "A torre do farol se eleva, mais alta a cada dia, conforme os hábeis pedreiros exercem sua profissão." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Os engenheiros estão dando os toques finais no farol. A qualquer momento, ele brilhará até léguas de distância, guiando os navios de volta para casa." },
    { TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "A construção do farol requer materiais estocados em um armazém, trabalhadores de um campo de trabalho, e arquitetos de uma guilda de arquitetura." },
    { TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "A luz no topo desta grande torre guia navios dos mais longínquos recantos do mundo em segurança até a cidade. Navios pesqueiros se movem 10% mais rápido. Tempestades marítimas duram metade do tempo." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Política comercial marítima" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Sem política comercial marítima." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Seleciona uma política comercial marítima para a cidade. Pode ser trocada por outra política a qualquer momento." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Política do vendedor marítimo: exportações marítimas ganham 20% a mais, mas importações são 10% mais caras." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Política do comprador marítimo: importações terrestres são 20% mais baratas, mas as exportações ganham 10% menos." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Política das quantidades marítimas: navios transportam 4 unidades adicionais de mercadorias, mas o Farol consome 20% mais madeira." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumentos" },
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "A imponente torre de pedra do farol, já completa, assuma sobre o horizonte. Que a sua chama guie os navios de volta para casa até o fim dos tempos." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "O Panteão está pronto. Sua monumentalidade é testemunho ímpar do incrível poder dos deuses e do povo de Roma!" },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monumento completo" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Uma bênção de Netuno" },
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Em recompensa à devoção de tua cidade, Netuno garante viagem segura aos mercadores por doze meses, período no qual tuas exportações lucrarão metade do preço a mais." },
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Uma bênção de Vênus" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Deleitada pela devoção tão alegremente demonstrada a ela, Vênus concede juventude, saúde e felicidade a teu povo, aumentando o tamanho da população economicamente ativa." },
    {TR_BUILDING_MENU_STATUES, "Estátuas" },
    {TR_BUILDING_MENU_GOV_RES, "Mansões do Governador" },
    {TR_OVERLAY_ROADS, "Estradas" },
    {TR_NO_EXTRA_ASSETS_TITLE, "Assets extra não foram carregados" },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Os assets extra do Augustus não foram carregados.\n"
        "Isto pode ser devido a uma pasta 'assets' antiga ou faltando.\n"
        "Certifique que tem a pasta 'assets' mais atual, que pode ser descarregada do GitHub." },
    {TR_WARNING_WATER_NEEDED_FOR_BUILDING, "O Farol deve ser posicionado perto da água" },
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Esta moradia tem acesso a todos os cinco deuses do Panteão" },
    {TR_BUILDING_LEGION_FOOD_BONUS, "A abundância de comida está melhorando o moral" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Condição da comida" },
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Permitir que o contramestre pegue comida daqui" },
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Não é possível adquirir os materiais necessários" },
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Santuários completos garantem +8 no índice de cultura" },
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Desativar geração infinita de lobos"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Voltar ao menu principal" },
    {TR_LABEL_PAUSE_MENU, "Pausa" },
    {TR_OVERLAY_LEVY, "Custos de manutenção" },
    {TR_TOOLTIP_OVERLAY_LEVY, " denários pagos mensalmente em custos de manutenção" },
    {TR_MAP_EDITOR_OPTIONS, "Configurações do cenário" },
    {TR_BUILDING_TAVERN, "Taberna" },
    {TR_BUILDING_GRAND_GARDEN, "Jardim suntuoso" },
    {TR_BUILDING_TAVERN_DESC_1, "Esta taberna não tem trabalhadores e não pode abrir para negócios." },
    {TR_BUILDING_TAVERN_DESC_2, "Esta taberna não tem vinho, e não pode abrir para negócios." },
    {TR_BUILDING_TAVERN_DESC_3, "Enquanto o vinho continuar fluindo, esta taberna oferecerá entretenimento. O suprimento de carne aumentaria a atração." },
    {TR_BUILDING_TAVERN_DESC_4, "O vinho em abundância e o cheiro da carne assada nesta taberna atraem uma freguesia vibrante, em busca de música, jogatina e diversão." },
    {TR_FIGURE_TYPE_BARKEEP, "Taberneira" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Provedora da taberna" },
    {TR_OVERLAY_TAVERN, "Taberna" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Esta moradia não tem acesso a uma taberna, ou a taberna local está sem vinho." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Nenhuma taberneira passou por aqui recentemente. Esta moradia logo perderá acesso à taberna." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Esta moradia foi visitada por uma taberneira de uma taberna com vinho." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Esta moradia foi visitada por uma taberneira de uma taberna com vinho e carne." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Esta moradia foi visitada recentemente por uma taberneira de uma taberna com vinho." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Esta moradia foi visitada recentemente por uma taberneira de uma taberna com vinho e carne. Que comece a diversão!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Os residentes abominam a mera mensão de teu nome."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Os residentes estão com muita raiva de ti." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Os residentes estão com raiva de ti." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Os residentes estão bastante irritados contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Os residentes estão irritados contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Os residentes estão descontentes contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Os residentes são indiferentes a ti." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Os residentes estão satisfeitos contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Os residentes estão bastante satisfeitos contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Os residentes estão bem felizes contigo." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Os residentes te amam." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Os residentes te idolatram como um deus." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Os residentes estão descontentes com os altos impostos." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Os residentes estão descontentes com os baixos salários." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Os residentes estão descontentes com a falta de empregos." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Os residentes estão desanimados por morarem nesta espelunca." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Os residentes anseiam por mais entretenimento." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Os residentes anseiam por uma dieta mais variada." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Os residentes gostariam que a vizinhança fosse mais atraente." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Os residentes estão felizes com os acontecimentos recentes." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Os residentes ficaram entristecidos com os acontecimentos recentes." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tabernas" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Jogos" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Patrocina Grandes Jogos no Coliseu, ao custo de economias pessoais e recursos da cidade." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Realizar jogos" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "A cidade se prepara pra os Grandes Jogos." },
    {TR_SELECT_GAMES_HEADER, "Jogos" },
    {TR_SELECT_GAMES_TEXT, "Os Jogos serão realizados no Coliseu, ao custo de economias pessoais e recursos da cidade." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_HORSE_STATUE, "Estátua equestre" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fonte de golfinho" },
    {TR_BUILDING_HEDGE_DARK, "Sebe verdejante" },
    {TR_BUILDING_HEDGE_LIGHT, "Sebe ensolarada" },
    {TR_BUILDING_GARDEN_WALL, "Muro de jardim" },
    {TR_BUILDING_LEGION_STATUE, "Estátua de legionário" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Coluna de mármore" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hipogeu)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fundação)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcadas)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galerias)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Os trabalhadores estão escavando o hipogeu - túneis subterrâneos e maquinarias de onde grandes espetáculos irão emergir." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "O Coliseu começa a tomar forma com a construção de arquibancadas destinadas tanto à plebe quanto a imperadores." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Arcos graciosos se elevam para sustentar o peso deste poderoso Coliseu." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Conforme o Coliseu ganha altura, suas paredes são decoradas com mármores reluzentes e estatuárias" },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Pista)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fundação)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Arquibancadas)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fachada)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Este gigantesco terreno está sendo arduamente aberto e nivelado para a execução de um projeto sem precedentes." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Galerias de acesso e estruturas de suporte estão sendo erguidas em torno da pista" },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Os pedreiros estão esculpindo arquibancadas para dezenas de milhares de espectadores." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Muito mais do que uma mera pista de corridas, artesãos agora dão forma a um monumento digno dos deuses e do povo de Roma." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "A construção deste monumento requer materiais estocados em um armazém, trabalhadores de um campo de trabalho e arquitetos de uma guilda de arquitetura." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construção interrompida." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenas" },
    {TR_BUILDING_INFO_TOURISM, "(viajantes)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "O Coliseu está pronto! Que comecem os jogos!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "O Hipódromo está pronto! Os cidadãos aguardam ansiosos o teu comando para dar início às corridas!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Jogos inaugurais" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Começam as corridas" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Os jogos inaugurais do Coliseu têm início. Ao teu comando, este monumento será consagrado com o sangue dos bravos!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "A cidade se esvazia conforme multidões fluem em direção ao Hipódromo para a corrida de bigas inaugural. Um clamor ensurdecedor toma o ar quando os portões são abertos ao público!" },
    {TR_WINDOW_GAMES_OPTION_1, "Realiza Jogos Navais" },
    {TR_WINDOW_GAMES_OPTION_2, "Realiza Jogos de Feras" },
    {TR_WINDOW_GAMES_OPTION_3, "Realiza as Calendas de Janeiro" },
    {TR_WINDOW_GAMES_OPTION_4, "Realiza Jogos Olímpicos" },
    {TR_WINDOW_GAMES_OPTION_5, "Realiza Jogos Romanos" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "O Coliseu será inundado para a reprodução de uma grande batalha naval. A velocidade de movimento e a força de tuas tropas em batalhas distantes será maior ao longo do próximo ano." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "O Coliseu apresentará terríveis caçadas de animais e execuções por bestas selvagens, para o deleite da plebe. Crime, tumultos e revoltas são suprimidos ao longo do próximo ano. Os gladiadores ajudarão na defesa da cidade durante a próxima invasão." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "O Coliseu realizará jogos em honra aos deuses no primeiro dia do próximo ano, rogando por fortuna e prosperidade. Ao longo do próximo ano as cotas comerciais serão dobradas." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "O Hipódromo sediará os próximos Jogos Olímpicos. A cidade receberá levas de visitantes, e, se os atletas locais fizerem juz à honra, esperamos um aumento permanente do turismo e do apreço." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "O Coliseu apresentará os Jogos Romanos; cidadãos virão de todos os cantos do Império até a cidade para competir. Um espetáculo de tamanha grandiosidade certamente há de conquistar o apreço do Imperador e da plebe pelo próximo ano." },
    {TR_WINDOW_GAMES_COST, "Custo:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(economias pessoais)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Economias pessoais insuficientes." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Recursos insuficientes em estoque." },
    {TR_WINDOW_GAMES_NO_VENUE, "Espaço não construído, ou sem trabalhadores." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construção)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Pedreiros e engenheiros estão construíndo este edifício sagrado com mármore reluzente." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "A construção deste templo requer materiais estocados em um armazém, trabalhadores de um campo de trabalho e arquitetos de uma guilda de arquitetura." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "A água dos reservatórios da cidade está lentamente inundando a arena do Coliseu. Os carpinteiros já começam a construir miniaturas realistas de navios de guerra enquanto os gladiadores treinam combate naval. Em breve os Jogos Navais terão início!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "O Coliseu se transformou em um lago artificial. Os gladiadores reencenam as grandes vitórias marinhas de Roma. Sangue e água se misturam sob o clamor da multidão extasiada. As Naumachia - Jogos Navais - começaram!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "O Coliseu agora passa por um longo processo de limpeza, enquanto é esvaziado e preparado para o uso cotidiano. O povo falará deste grande espetáculo aquático por anos a fio." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Carregamentos exóticos começam a aparecer na cidade conforme mercadores dos mais longínquos recantos da Terra trazem feras selvagens às gaiolas subterrâneas do Coliseu. Em breve um espetáculo sangrento levará o povo ao deleite." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Criminosos condenados e gladiadores em busca da maior de todas as glórias encaram a morte na forma de presas e garras. Com o soar das trombetas, têm início os Jogos de Feras!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "A última das feras selvagens jaz abatida sobre as areias do Coliseu, seu sangue misturado ao dos condenados. Os Jogos de Feras chegam ao fim." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Saudaremos o ano novo com jogos gloriosos em homenagem aos deuses. Em retorno, pedimos por fortuna, prosperidade, e bênçãos para os negócios." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Os Jogos têm início ao raiar do sol das Calendas de Janeiro. Os sacerdotes conduzem os sacrifícios de animais enquanto os gladiadores cingem seus braços, dispostos a morrer em busca da aprovação divina."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Os augúrios indicam que os deuses ficaram satisfeitos com  nossos grandes jogos e com os sacrifícios e reverência a eles demonstrada. Esperamos por um ano de lucros vultosos!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Todos os olhos estarão voltados para a nossa cidade enquanto os Jogos Olímpicos atraem viajantes, competidores, e dignitários romanos de todas as partes do mundo. Um ano inteiro de preparativos pode ser necessário até que tudo esteja pronto."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Finalmente é chegada a hora. A pira sagrada foi acesa, e as ruas da cidade estão desertas com o povo lotando o hipódromo. Que comecem os Jogos Olímpicos!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "A pira sagrada se apaga. Viajantes e cidadão retornam para casa após esta exaustiva vibração. Glória eterna recai sobre ti por teres patrocinado com sucesso esta antiga e sagrada celebração de força e honra." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Com o anúncio dos Jogos Romanos, pessoas dos mais longínquos recantos dirigem-se à cidade, na esperança de vencer alguma das muitas competições. Um ano inteiro de preparativos pode ser necessário até que tudo esteja pronto." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "A procissão solene tem início e, com ela, os Jogos Romanos. Que o próprio Júpiter selecione os campeões das corridas, lutas, e demais competições de resistência e agilidade. O Coliseu está lotado de espectadores, que aguardam o início dos jogos e as costumeiras distribuições de trigo e azeite. Que tenham início os Jogos Romanos!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Termina o último dia dos Jogos Romanos. Transbordando de excitação, e de barrigas cheias, todos os cidadãos puderam ter uma prova da grandiosidade da vida romana. Glória aos deuses, aos vitoriosos e ao governador!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Os Grandes Jogos"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Meses até que novos Jogos possam ser realizados: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Meses até os Jogos Navais:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Os Jogos Navais estão sendo realizados. O salpicar das águas, o ranger das tábuas e os gritos de batalha dos gladiadores se somam ao clamor da multidão." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Meses até os Jogos de Feras:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Os Jogos de Feras estão sendo realizados. Ombro a ombro, a multidão vai ao delírio enquanto as feras selvagens perseguem presas humanas." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Meses até as Calendas de Janeiro:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Os Jogos das Calendas de Janeiro estão sendo realizados. O odor dos sacrifícios de animais e do incenso se sobrepõe até mesmo ao cheiro pungente do sangue e do suor da arena." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Meses até os Jogos Olímpicos:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Os Jogos Olímpicos estão sendo realizados. A pira sagrada arde dia e noite enquanto os atletas competem pela glória imortal." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Meses até os Jogos Romanos:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Os Jogos Romanos estão sendo realizados. Cada participante derrama de seu sangue, suor e lágrimas a fim de se provar o melhor dos romanos." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Os Grandes Jogos continuarão por mais" }, // ...XX Dias, 
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Grandes Jogos foram realizados recentemente." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Os Grandes Jogos estão sendo realizados! A cidade se enche de viajantes e de folia." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "A arena está fechada. Os pássaros fazem seus ninhos nas arquibancadas vazias." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Esta arena não tem apresentações nem com leões nem com gladiadores, e provém pouco entretenimento." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Esta arena apresenta gladiaturas e caçadas com animais, para o deleite da multidão." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Apresentações regulares de gladiaturas entretêm a multidão, mas lutas com leões elevariam o padrão do espetáculo." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Feras famintas rondam a arena em busca de presas, mas o espetáculo é curto, devido à ausência de gladiadores treinados." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Este templo coletará comida para o Posto de Suprimentos, assim que ficar pronto." },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Esta moradia não tem acesso nem a uma arena nem ao Coliseu." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Esta moradia tem acesso a uma arena com um tipo de espetáculo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Esta moradia tem acesso a uma arena com dois tipos de espetáculo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Esta moradia tem acesso ao Coliseu, com um tipo de espetáculo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Esta moradia tem acesso ao Coliseu, com dois tipos de espetáculo." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Trabalhadores em greve" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Sem acesso a água" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Esperando por um carroceiro" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Não há recursos disponíveis" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Edifício fechado" },
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Muitos edifícios deste tipo -- os viajantes evitam este lugar." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Receita de viajantes este ano:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "O Conselheiro do Comércio ordenou a suspensão da pesca."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tributo/juros"},
    {TR_WINDOW_ADVISOR_TOURISM, "Miscelânea"},
    {TR_WINDOW_FIGURE_TOURIST, "Este viajante gastou: "},
    {TR_FIGURE_TYPE_TOURIST,  "Viajante"},
    {TR_MAP_EDITOR_OPTIONS, "Configurações do cenário" },
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Versão de jogo salvo incompatível" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "O jogo salvo que você está tentando abrir é de uma versão mais recente de Augustus.\nPor favor atualize o Augustus para a versão mais recente." },
    {TR_BUILDING_COLONNADE, "Colunata" },
    {TR_BUILDING_LARARIUM, "Larário" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Este pequeno altar é dedicado aos espíritos ancestrais do povo romano. As pessoas vêm aqui para realizar pequenos sacrifícios e preces."},
    {TR_BUILDING_WATCHTOWER, "Atalaia"},
    {TR_BUILDING_WATCHTOWER_DESC, "Os arqueiros nas ameias desta torre mantêm vigia em busca de invasores enquanto sentinelas patrulham as estradas abaixo." },
    {TR_BUILDING_NYMPHAEUM, "Ninfeu"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Este grande templo é dedicado às ninfas aquáticas - deidades da primavera, dos rios e do mar. Oferece beleza e abundância para a vizinhança e apreço divino para a cidade." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Mausoléu pequeno"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Este edifício é o local de descanso final de gerações passadas de famílias abastadas da cidade, inveja de muitos dentre os vivos." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Mausoléu grande"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "As paredes de mármore reluzente e as estátuas deste magnífico edifício refletem os grandes feitos dos patrícios dignos do privilégio de jazerem aqui." },
    {TR_FIGURE_TYPE_WATCHMAN, "Sentinela" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Este templo coletará comida para o Posto de Suprimentos, assim que ficar pronto." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Mudar acesso para prefeitos e engenheiros" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Mudar acesso para sacerdotes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Mudar acesso para distribuidoras do mercado" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Mudar acesso para artistas" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Mudar acesso para professores e estudantes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Mudar acesso para profissionais de saúde" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Mudar acesso para cobradores de impostos" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Mudar acesso para recrutador de trabalhadores" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Mudar acesso para diplomata" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Mudar acesso para sentinela" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Atalho já utilizado"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Esta combinação de teclas já está designada para a seguinte ação:"},
    {TR_BUILDING_GARDEN_PATH, "Caminho de jardim" },
    {TR_BUTTON_GO_TO_SITE, "Vá para o local" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Interromper construção" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Retomar construção" },
    {TR_RESOURCE_FISH, "Peixe" },
    {TR_WARNING_VARIANT_TOGGLE, "Pressiona a tecla de rotação para circular por variações deste edifício"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Esta escola está em funcionamento. O desenvolvimento local permitiu que os cidadãos expandissem o edifício, garantindo espaço para mais crianças."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Este teatro está em funcionamento. O desenvolvimento local permitiu que os cidadãos expandissem o edifício, disponibilizando mais assentos." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Esta biblioteca está em funcionamento. O desenvolvimento local permitiu que os cidadãos expandissem o edifício, disponibilizando mais prateleiras e rolos de pergaminhos." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Este canteiro de obras não tem acesso a uma estrada e não pode receber materiais para construção. Conecta uma estrada a um dos quadrados centrais."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Devido ao baixo moral da cidade, os plebeus desta oficina decretaram greve e se recusam a trabalhar!" },
    {TR_CITY_WARNING_SECESSION, "Os plebeus se recusam a trabalhar!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Um armazém foi saqueado!" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Um celeiro foi saqueado!" },
    {TR_CITY_WARNING_THEFT, "Fundos foram roubados de um fórum ou do Senado!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Saque na cidade!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Um armazém ou celeiro foi saqueado por cidadãos irados e bens foram roubados! Baixo moral torna esses incidentes mais prováveis."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasões" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasão em andamento" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Sem invasões" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasão iminente" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Inimigos se aproximam" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Inimigos distantes" },
    {TR_SIDEBAR_EXTRA_GODS, "Deuses" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Ver tudo"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Pequena força"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Força mediana"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Grande força"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Enviar pedido"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Estoque"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Pare de armazenar"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Ir para gráficos de população" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visita o Conselheiro de Habitação" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Este monumento tem todos os mateirais necessários para a fase atual. Os trabalhadores aguardam a chegada de um arquiteto de uma Guilda de Arquitetura para vistoriar o prosseguimento da construção." },
    { TR_RETURN_ALL_TO_FORT, "Voltar tudo" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informação sobre os Jogos" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Esta estátua parecerá ainda mais grandiosa com a fonte em funcionamento. Providencia acesso ao abastecimento de água." },
    {TR_OPTION_MENU_APPLY, "Aceitar" },
    {TR_OPTION_MENU_COST, "Esta ação tem um custo de"},
    {TR_FIGURE_TYPE_LOOTER, "Saqueador" },
    {TR_FIGURE_TYPE_ROBBER, "Ladrão" },
    {TR_OVERLAY_SENTIMENT, "Moral" },
    {TR_OVERLAY_EFFICIENCY, "Eficácia:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Ninguém" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Toda a população" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Seleciona uma política comercial terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Um caravançará é necessário para estabelecer uma política comercial terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Seleciona uma política comercial marítima"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Um farol é necessário para estabelecer uma política comercial marítima"},
    {TR_TOOLTIP_HOLD_GAME, "Realizar Jogos"},
    {TR_TOOLTIP_NO_GAME, "Não realizar Jogos"},
    {TR_WARNING_NEARBY_WOLF, "Não é possível construir com lobos por perto" },
    {TR_MARKET_TRADING, "Comercializando"},
    {TR_MARKET_NOT_TRADING, "Não comercializando"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuindo"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Não distribuindo"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Moradias decrépitas e favelas previnem a imigração"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Faroleiro"},
    {TR_CITY_MESSAGE_SQUALOR, "Moradias decrépitas e favelas são um problema" },
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Faroleiro" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "O edifício não tem acesso a um reservatório." },
    {TR_HOTKEY_COPY_SETTINGS, "Copiar configurações do edifício" },
    {TR_HOTKEY_PASTE_SETTINGS, "Colar configurações do edifício" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Larários na cidade" },
    {TR_WINDOW_RACE_BET_BUTTON, "apostar em um cavalo" },
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Corrida em andamento..." },
    {TR_WINDOW_RACE_BET_TITLE, "Aposta em um cavalo" },
    {TR_WINDOW_RACE_BET_AMOUNT, "Quantia" },
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Aposta uma quantia de tuas economias pessoais no time de bigas de tua escolha, e dobra o valor se o cavalo escolhido vencer. Teus ganhos podem até mesmo quadruplicar durante jogos do Coliseu!" },
    {TR_WARNING_BET_VICTORY, "Teu cavalo venceu a corrida no hipódromo da cidade" },
    {TR_WARNING_BET_DEFEAT, "Teu cavalo perdeu a corrida no hipódromo da cidade" },
    {TR_PERSONAL_SAVINGS, "Economias :" },
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Aposta no cavalo azul" },
    {TR_WINDOW_RACE_BET_RED_HORSE, "Aposta no cavalo vermelho" },
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Aposta no cavalo branco" },
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Aposta no cavalo verde" },
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Sem um corpo completo de sacerdotes e atendentes, este templo é incapaz de realizar todos os ritos sagrados e cerimônias. Deves tomar providências, os deuses não olham este tipo de negligência com bons olhos." },
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Não há funcionários o suficiente no Coliseu. É preciso de mais trabalhadores para garantir que todos os cidadãos possam aproveitar os jogos." },
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Não há funcionários o suficiente no Hipódromo. É preciso de mais trabalhadores para realizar espetáculos grandiosos para a população." },
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Sem trabalhadores o suficiente, este Farol não tem como manter sua chama acesa. Os navios se arriscam às cegas tentando chegar às docas da cidade." },
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Não há trabalhadores o suficiente no Caravançará para atender a todas as caravanas." },
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Muro de jardim coberto" },
    {TR_BUILDING_GARDEN_WALL_GATE, "Portão de jardim" },
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Este portão controla a passagem para dentro e para fora dos recantos mais isolados da cidade." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "O carroceiro está a caminho de outro armazém para recolher os bens desejados." },
    {TR_BUILDING_PALISADE, "Paliçada" },
    {TR_BUILDING_PALISADE_DESC, "Este mote, acimado por uma cerca de estacas afiadas, mantém a cidade a salvo de invasores e animais selvagens." },
    {TR_OVERLAY_MOTHBALL, "Fechado" },
    {TR_OVERLAY_ENEMY, "Inimigos" },
    {TR_BUILDING_TAVERN_DESC_5, "Os cidadãos adoram visitar este estabelecimento nos seus tempos livres para socializar à base de vinho e de boa comida." },
    {TR_OVERLAY_WAREHOUSES, "Armazéns" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Time Azul - os favoritos de Netuno. Os jovens corredores mais promissores de Roma, que anseiam por se provar dignos." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Time Vermelho - conhecido como o time do mais bem sucedido corredor da história de Roma - um antigo remador, que salvou a vida de um cônsul romano." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Time Branco - fundado por ex-gladiadores. Têm o combate no sangue, e mesmo como homens livres seguem vivendo pelo desafio." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Time Verde - descendentes dos cavaleiros \"Celeres\", da época do Reino de Roma. Ainda bravatam serem os melhores dos melhores." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Retomar a distribuição de recursos" },
    {TR_CONFIG_VIDEO_SOUND, "Ativar som do vídeo" },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Esta torre precisa de um sentinela do quartel para que possa ser útil na defesa da cidade." },
    {TR_CONFIG_INFINITE, "Ilimitado" },
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Número máximo de Santuários por cidade:" },
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Rotação anterior da construção" },
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Suspender recursos para fábricas e celeiros" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Permitir estocagem em um armazém" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Desabilitar estocagem" },
    {TR_CONFIG_DIGIT_SEPARATOR, "Separar dígitos"},
    {TR_WARNING_SCREENSHOT_SAVED, "Captura de tela salva: "},
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "A peste se abateu sobre a cidade! Muitos moradores adoeceram e alguns edifícios foram colocados em quarentena ou queimados de maneira a prevenir o alastramento da doença. Os poucos médicos e cirurgiões disponíveis foram convocados para descontaminar as áreas mais afetadas. Toma uma ação de imediato!" },
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "A cidade é atendida por um coliseu" },
    {TR_ADVISOR_ACTIVE_HIPPODROME, "A cidade é atendida por um hipódromo" },
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "Sem coliseu em funcionamento na cidade" },
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "Sem hipódromo em funcionamento na cidade" },
    {TR_ADVISOR_POPULATION_AGE, "idade" },
    {TR_ADVISOR_POPULATION_DWELLERS, "moradores" },
    {TR_ADVISOR_POPULATION_RESIDENTS, "residentes" },
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Algumas áreas da cidade são flageladas por doenças infecciosas. Se a situação não for logo remediada, alguns edifícios terão de ser postos em quarentena. Um melhor acesso aos serviços de saúde seria uma medida eficaz para frear o avanço de doenças neste local." },
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Doenças são raras nesta cidade. A alta qualidade dos serviços de saúde providos aos moradores impede com bastante eficácia a disseminação de doenças vindas de fora." },
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Alguuns casos de doenças infecciosas foram identificados na cidade, mas a situação está sob controle. Serviços de saúde de melhor qualidade hão de mitigar o impacto de epidemias na cidade." },
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "Esta academia está funcionando. O desenvolvimento local permitiu aos cidadãos expandir o edifício, garantindo mais espaço para orações e pesquisas." },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "A peste foi trazida por um navio mercante. Este cais ficará em quarentena até que um médico ou cirurgião descontamine o local." },
    {TR_BUILDING_FUMIGATION_DESC, "O edifício está sendo descontaminado. A fumigação deve durar alguns dias." },
    {TR_BUILDING_GLADIATOR_STATUE, "Estátua de gladiador" },
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "A peste foi trazida por um trabalhador contaminado. Este celeiro ficará em quarentena enquanto um médico ou cirurgião descontamina a área." },
    {TR_BUILDING_HOUSE_DISEASE_DESC, "A peste se abateu sobre nós! Sem serviçoes de saúde adequados, os moradores deste local morreram doentes. Esta moradia ficará em quarentena até que um médico ou cirurgião descontamine o local." },
    {TR_BUILDING_PALISADE_GATE, "Portão de paliçada" },
    {TR_BUILDING_PALISADE_GATE_DESC, "Este portão estreito de madeira controla o movimento de pessoas para dentro e para fora das defesas da cidade." },
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "A peste foi trazida por um trabalhador contaminado. Este armazém ficará em quarentena enquanto um médico ou cirurgião descontamina a área." },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Eficácia:" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "A eficácia é a razão entre o quanto o edifício consegue produzir em um ano e o quando ele de fato produziu ao longo do último ano." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "Este edifício é pouco eficaz. Uma possível razão para isso é a ausência de um destino próximo para os bens aqui produzidos." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "Este edifício é pouco eficaz. Possíveis razões para isso são a ausência de um suprimento constante de matérias primas ou de um destino próximo para os bens aqui produzidos." },
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Média mensal de pesca:" },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Autosave anual DESLIGADO" },
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Autosave anual LIGADO" },
    {TR_CHEAT_ADDED_MONEY, "Denários adicionados" },
    {TR_CHEAT_CASTED_BLESSING, "Bênção invocada" },
    {TR_CHEAT_FINISHED_MONUMENTS, "Monumentos completados" },
    {TR_CHEAT_INCITED_RIOT, "Tumulto incitado" },
    {TR_CHEAT_KILLED_ALL_WALKERS, "Todos os caminhantes mortos" },
    {TR_CHEAT_STARTED_INVASION, "Invasão iniciada" },
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Mostrar dicas de ferramenta" },
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "Todos os edifícios desbloqueados" },
    {TR_CHEAT_UPDATED_MONUMENTS, "Monumentos evoluídos" },
    {TR_CHEAT_YEAR_ADVANCED, "Avanço de um ano" },
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "Perdeste o apreço de César, por isso tua prisão foi decretada! A menos que restores o apreço do imperador, suas legiões de elite logo atacarão a cidade." },
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Humpf! Esta cidade patética não tem mais nada que valha ser destruído. Partiremos por enquanto, mas acautela-te: sempre podemos voltar!" },
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Marte está irado! Tens pouco a temer nesta terra pacífica, mas esteja certo disso: a paz não há de durar para sempre!" },
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "A peste se abateu sobre a cidade! Um edifício está em quarentena e médicos e cirurgiões foram convocados para descontaminá-lo." },
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "A fúria do imperador" },
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "Inimigos recuando" },
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Ira de Marte" },
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "Peste na cidade" },
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Impossível copiar deste edifício" },
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Configurações copiadas" },
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Impossível colar" },
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Configurações coladas" },
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Sempre mostrar botões de rotação" },
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Arrastamento invertido do mapa com o botão direito do mouse" },
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Mostrar novas mensagens como alertas ao invés de popups" },
    {TR_CONFIG_UI_SHOW_GRID, "Mostrar grade" },
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Mostrar grade parcial em torno de um edifício" },
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Enviando os bens requesitados para Roma" },
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Fazenda de trigo" },
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Rotacionar o mapa para o NORTE" },
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Salvar captura de tela do minimapa" },
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Mostrar mapa do império" },
    {TR_HOTKEY_SHOW_MESSAGES, "Mostrar mensagens" },
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Cobertura de academias" },
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Cobertura de barbeiros" },
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Cobertura de balneários" },
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Cobertura de clínicas" },
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Visão da atratividade" },
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Visão da educação" },
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Visão do entretenimento" },
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Visão dos estoques de comida" },
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Cobertura de hospitais" },
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Visão de taxações" },
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Cobertura de biblioteca" },
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "Visão de edifícios desligados" },
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Visão da Religião" },
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Visão de estradas" },
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Cobertura de escolas" },
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Visão de moral" },
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Visão de doenças" },
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Visão de impostos" },
    {TR_OUT_OF_MONEY, "Sem denários" },
    {TR_OVERLAY_SICKNESS, "Doença" },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "Não foi possível salvar o jogo.\nVerifique se a pasta onde o Caesar 3 mantém os jogos salvos só permite acesso por administrador.\nMova a pasta do Caesar 3 para um local que não requeira acesso de administrador ou inicie o Augustus como administrador (não recomendado)." },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Não é possível salvar o jogo" },
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Cenário personalizado" },
    {TR_SAVE_DIALOG_DATE, "Data:" },
    {TR_SAVE_DIALOG_FIRST_MISSION, "Primeira missão" },
    {TR_SAVE_DIALOG_FUNDS, "Fundos:" },
    {TR_SAVE_DIALOG_INVALID_FILE, "Arquivo inválido" },
    {TR_SAVE_DIALOG_MILITARY, "Militar" },
    {TR_SAVE_DIALOG_MISSION, "Missão" },
    {TR_SAVE_DIALOG_PEACEFUL, "Pacífica" },
    {TR_SAVE_DIALOG_POPULATION, "População:" },
    {TR_SAVE_DIALOG_SELECT_FILE, "Selecione um arquivo" },
    {TR_TOGGLE_GRID, "Ligar grade" },
    {TR_TOOLTIP_MONUMENT_PHASE, " fase. " },
    {TR_TOOLTIP_MONUMENT_PHASES, " fases. " },
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Recursos necessários:\n" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Sem trabalhadores" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "O edifício está com a peste" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Muitas doenças infecciosas se espalhando" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Poucas doenças" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Algumas doenças infecciosas" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "A peste ronda esta região" },
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Posto diplomático" },
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( frame da animação )" },
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Item:" },
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Itens atualizados" },
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Grupo:" },
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "Nenhum item" },
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "( nenhum grupo )" },
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Rodar animações" },
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Sair" },
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Atualizar" },
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Mostrar frames da animação" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Terreno:" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Central" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Desértico" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "Nenhum" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Setentrional" },
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Prévia do item" },
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( item sem nome )" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "O carroceiro está retornando com uma encomenda." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "O carroceiro está indo buscar comida de outro celeiro." },
    {TR_WINDOW_RACE_YOUR_BET, "Tua aposta" },
    {TR_ZOOM, "Zoom:" },
    {TR_BUILDING_CITY_MINT, "Casa da Moeda" },
    {TR_BUILDING_CITY_MINT_DESC, "Neste local, ouro é usado para cunhar moedas, que vão para os cofres da cidade." },
    {TR_BUILDING_CITY_MINT_DESC_NO_PALACE, "Constrói o teu palácio para também colher economias pessoais da Casa da Moeda." },
    {TR_BUILDING_CITY_MINT_DESC_PALACE, "Já que tens um palácio, mais moedas são adicionadas às tuas reservas pessoais." },
    {TR_BUILDING_CITY_MINT_FEW_EMPLOYEES, "Quase sem trabalhadores essa oficina está com o seu funcionamento praticamente interrompido e não cunhará quase nenhuma moeda ao longo do ano." },
    {TR_BUILDING_CITY_MINT_FULL_EMPLOYEES, "A Casa da Moeda tem todos os funcionários de que necessita. A cunhagem vai de vento em popa." },
    {TR_BUILDING_CITY_MINT_HALF_EMPLOYEES, "A Casa da Moeda precisa de mais trabalhadores. A cunhagem está levando mais tempo do que o normal." },
    {TR_BUILDING_CITY_MINT_MANY_EMPLOYEES, "A Casa da Moeda está trabalhando abaixo de sua capacidade máxima. A cunhagem levará um pouco mais de tempo do que o normal." },
    {TR_BUILDING_CITY_MINT_NO_EMPLOYEES, "A Casa da Moeda está sem trabalhadores. Nenhuma moeda está sendo cunhada." },
    {TR_BUILDING_CITY_MINT_NO_GOLD, "Esta oficina precisa do fornecimento de ouro de um armazém ou mina de ouro para que possa cunhar moedas." },
    {TR_BUILDING_CITY_MINT_NO_SENATE, "A cidade precisa de um Senado em funcionamento para que este edifício possa cunhar moedas." },
    {TR_BUILDING_CITY_MINT_PHASE_1, "(Fundação)" },
    {TR_BUILDING_CITY_MINT_PHASE_1_TEXT, "Os engenheiros assentam a fundação deste edifício." },
    {TR_BUILDING_CITY_MINT_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso o processo de cunhagem está bem lento." },
    {TR_BUILDING_CITY_MINT_STORED_GOLD, "Ouro armazenado," },
    {TR_BUILDING_GOLD_MINE, "Mina de ouro" },
    {TR_BUILDING_GOLD_MINE_COMPLETE, "completo." },
    {TR_BUILDING_GOLD_MINE_DESC, "Minera ouro para o comércio ou para abastecer a Casa da Moeda e gerar denários." },
    {TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES, "Com quase nenhum minerador trabalhando aqui, a mineração está praticamente interrompida. Pouco ouro será extraído ao longo do ano." },
    {TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES, "Esta mina tem todos os funcionários de que necessita. A mineração vai de vento em popa." },
    {TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES, "Esta mina precisa de mais trabalhadores. A mineração está levando mais tempo do que o normal." },
    {TR_BUILDING_GOLD_MINE_HALTED, "O Conselheiro do Comércio ordenou a interrupção da mineração de ouro." },
    {TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES, "Esta mina está trabalhando abaixo de sua capacidade máxima. A mineração seria mais eficiente com mais trabalhadores." },
    {TR_BUILDING_GOLD_MINE_NO_EMPLOYEES, "Esta mina está sem trabalhadores. Nem mesmo uma pepita de ouro é extraída aqui." },
    {TR_BUILDING_GOLD_MINE_PRODUCTION, "A produção está" },
    {TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso a extração de ouro está bem lenta." },
    {TR_BUILDING_GRANARY_NO_FOOD, "Este celeiro está vazio." },
    {TR_BUILDING_HIGHWAY, "Estrada Imperial" },
    {TR_BUILDING_HIGHWAY_DESC, "As Estradas Imperiais permitem que os cidadãos alcancem seus destinos mais rápido." },
    {TR_BUILDING_WAREHOUSE_NO_GOODS, "Este armazém está vazio." },
    {TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING, "A estrada para Roma foi obstruída. A menos que o acesso seja restaurado imediatamente, os engenheiros de Roma serão obrigados a tomar medidas drásticas." },
    {TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING, "Cidade inacessível" },
    {TR_CITY_WARNING_BUILD_GOLD_MINE, "Constrói uma mina de ouro" },
    {TR_CITY_WARNING_BUILD_SENATE, "Constrói um Senado" },
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "O edifício está em funcionamento" },
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "O edifício está fechado" },
    {TR_CITY_WARNING_GOLD_NEEDED, "Esta oficina precisa de ouro" },
    {TR_CITY_WARNING_SENATE_NEEDED, "Esta oficina precisa de um Senado em funcionamento" },
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Animais inofensivos serão mortos automaticamente" },
    {TR_CONFIG_SHOW_MARKET_RANGE, "Mostra o alcance ao construir mercados" },
    {TR_CONFIG_SHOW_ROAMING_PATH, "Revela previamente os caminhos feitos pelos andarilhos" },
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Mostra o alcance de fontes e poços ao construir moradias" },
    {TR_EDITOR_CHOOSE_CUSTOM_EMPIRE, "Escolhe império personalizado" },
    {TR_EDITOR_CITY_PREVIEW, "Visualização da cidade: " },
    {TR_EDITOR_CURRENT_COORDS, "Coordenadas atuais: " },
    {TR_EDITOR_CUSTOM_EMPIRE_TITLE, "Carregando um império" },
    {TR_EDITOR_FAVOUR_DISFAVOR, "Apreço perdido por prorrogação" },
    {TR_EDITOR_FAVOUR_EXTENSION_MONTHS, "Prorrogação permitida em meses" },
    {TR_EDITOR_FAVOUR_IGNORED, "Apreço perdido por solicitação ignorada" },
    {TR_EDITOR_MAX_WAGES, "No máximo" },
    {TR_EDITOR_MIN_WAGES, "No mínimo" },
    {TR_EDITOR_REFRESH_EMPIRE, "Recarregar (F5)" },
    {TR_EDITOR_SELECTED_COORDS, "Coordenadas selecionadas: " },
    {TR_EDITOR_SHORT_ROUTE_TEXT, "rt" },
    {TR_EDITOR_TOGGLE_INVASIONS, "Selecionar invasões" },
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE, "Por favor, confira augustus-log.txt na sua pasta Augustus para mais informações." },
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE, "Não foi possível carregar império personalizado" },
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Fechar/abrir edifício" },
    {TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY, "Visão de eficiência" },
    {TR_HOTKEY_SPECIAL_ORDERS, "Mostrar encomendas especiais" },
    {TR_RESOURCE_GOLD, "Ouro" },
    {TR_SAVE_DIALOG_INCOMPATIBLE_VERSION, "Versão incompatível" },
    {TR_TAVERN_FETCHING, "Buscando" },
    {TR_TAVERN_NOT_FETCHING, "Não buscando" },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_0, "Ninguém sabe dizer quando foi a última vez que este edifício esteve em funcionamento." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_1, "Este edifício não produz praticamente nada." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_2, "Este edifício poderia ser mais eficaz e produzir muito mais." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_3, "O trabalho é constantemente interrompido nesse edifício, por isso sua eficiência é baixa." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_4, "Este eficío é produtivo e a produção tem poucas interrupões." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_5, "Este edifício funciona com máxima eficácia!" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "Sem doenças" },
    {TR_ACTION_TYPE_ADJUST_CITY_HEALTH, "Editar saúde" },
    {TR_ACTION_TYPE_ADJUST_FAVOR, "Editar apreço" },
    {TR_ACTION_TYPE_ADJUST_MONEY, "Editar dinheiro" },
    {TR_ACTION_TYPE_ADJUST_ROME_WAGES, "Editar salário de Roma" },
    {TR_ACTION_TYPE_ADJUST_SAVINGS, "Editar economias pessoais" },
    {TR_ACTION_TYPE_A_MESSAGE, "Uma mensagem" },
    {TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE, "Demolição forçada" },
    {TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS, "Habilitar ou deabilitar edifício" },
    {TR_ACTION_TYPE_CHANGE_CITY_RATING, "Editar índice da cidade" },
    {TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE, "Mudar valor de variável personalizada" },
    {TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED, "Mudar recursos disponíveis" },
    {TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES, "Mudar estoques de recursos" },
    {TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY, "Converter furura cidade comercial" },
    {TR_ACTION_TYPE_GLADIATOR_REVOLT, "Iniciar revolta de gladiadores" },
    {TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START, "Iniciar solicitação imediatamente" },
    {TR_ACTION_TYPE_SEND_STANDARD_MESSAGE, "Enviar mensagem padrão" },
    {TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE, "Mostrar mensagem personalizada" },
    {TR_ACTION_TYPE_TAX_RATE_SET, "Definir imposto" },
    {TR_ACTION_TYPE_TRADE_ADJUST_PRICE, "Ajustar preço" },
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT, "Ajustar quantidade comercializada na rota" },
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE, "Mudar preço de abertura de rota" },
    {TR_ACTION_TYPE_TRADE_PROBLEM_LAND, "Iniciar interrupção de rota terrestre" },
    {TR_ACTION_TYPE_TRADE_PROBLEM_SEA, "Iniciar interrupção de rota marítima" },
    {TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE, "Adicionar recurso em rota comercial" },
    {TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN, "Abrir rota" },
    {TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY, "Definir apenas preço de compra" },
    {TR_ACTION_TYPE_TRADE_SET_PRICE, "Definir preço" },
    {TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY, "Definir apenas preço de venda" },
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE, "Não pode ser estocado" },
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE, "Este recurso não pode ser estocado nem comercializado" },
    {TR_BUILDING_BRICKWORKS, "Fábrica de tijolos" },
    {TR_BUILDING_BRICKWORKS_COMPLETE, "completo." },
    {TR_BUILDING_BRICKWORKS_DESC, "Aqui areia e argila são usados para fazer tijolos para a construção de monumentos." },
    {TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES, "Quase sem trabalhadores, essa oficina está com o seu funcionamento praticamente interrompido e produzirá poucos tijolos ao longo do ano." },
    {TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES, "Essa fábrica tem todos os funcionários de que necessita. A produção de tijolos vai de vento em popa." },
    {TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES, "Essa fábrica precisa de mais trabalhadores. A produção de tijolos está levando mais tempo do que o normal." },
    {TR_BUILDING_BRICKWORKS_HALTED, "O Conselheiro do Comércio ordenou a suspensão da produção de tijolos." },
    {TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES, "Essa fábrica está trabalhando abaixo de sua capacidade máxima. A produção de tijolos seria mais rápida se houvesse mais trabalhadores." },
    {TR_BUILDING_BRICKWORKS_NO_EMPLOYEES, "Essa fábrica está sem trabalhadores. Nenhum tijolo será produzido." },
    {TR_BUILDING_BRICKWORKS_NO_RESOURCES, "Essa fábrica precisa que argila e areia de um armazém ou de minas para funcionar." },
    {TR_BUILDING_BRICKWORKS_PRODUCTION, "A produção está" },
    {TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso a fabricação de tijolos está bem lenta." },
    {TR_BUILDING_BRICKWORKS_STORED_CLAY, "Argila estocada," },
    {TR_BUILDING_BRICKWORKS_STORED_SAND, "Areia estocada," },
    {TR_BUILDING_CARAVANSERAI_PHASE_2, "(Colunata)" },
    {TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT, "Os pedreiros estão construindo uma colunata retangular. Ela proporcionará abrigo para os mercadores e seus animais." },
    {TR_BUILDING_CAT_DEPOT, "É uma cilada, Bichano!" },
    {TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION, "Mudar a produção da casa da moeda?" },
    {TR_BUILDING_CITY_MINT_CONVERT, "Converter:" },
    {TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE, "Aqui moedas são derretidas para extração de ouro, que pode ser usado na construção de monumentos." },
    {TR_BUILDING_CITY_MINT_DN_TO_GOLD, "600 denários para uma carroça de ouro" },
    {TR_BUILDING_CITY_MINT_GOLD_TO_DN, "Uma carroça de ouro para 500 denários" },
    {TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST, "A produção atual será perdida." },
    {TR_BUILDING_CONCRETE_MAKER, "Fábrica de concreto" },
    {TR_BUILDING_CONCRETE_MAKER_COMPLETE, "completo." },
    {TR_BUILDING_CONCRETE_MAKER_DESC, "Aqui areia é misturada com água para a produção de concreto para os monumentos." },
    {TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES, "Quase sem trabalhadores, essa oficina está com o seu funcionamento praticamente interrompido e produzirá pouco concreto ao longo do ano." },
    {TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES, "Essa fábrica tem todos os funcionários de que necessita. A produção de concreto vai de vento em popa." },
    {TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES, "Essa fábrica precisa de mais trabalhadores. A produção de concreto está levando mais tempo do que o normal." },
    {TR_BUILDING_CONCRETE_MAKER_HALTED, "O Conselheiro do Comércio ordenou a suspensão da produção de concreto." },
    {TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS, "Essa fábrica tem acesso apenas a água de poço ou de fonte. A produção poderia ser otimizada se houvesse acesso direto a um reservatório." },
    {TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES, "Essa fábrica está trabalhando abaixo de sua capacidade máxima. A produção de concreto seria mais rápida se houvesse mais trabalhadores." },
    {TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES, "Essa fábrica está sem trabalhadores. A produção está interrompida." },
    {TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES, "Essa fábrica precisa de água de um reservatório, fonte ou poço, além de areia de um armazém ou mina, para a mistura do concreto." },
    {TR_BUILDING_CONCRETE_MAKER_NO_TARGETS, "Nenhuma construção precisa de concreto. A produção foi interrompida." },
    {TR_BUILDING_CONCRETE_MAKER_PRODUCTION, "A produção está" },
    {TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso a produção de concreto está bem lenta." },
    {TR_BUILDING_CONCRETE_MAKER_STORED_SAND, "Areia estocada," },
    {TR_BUILDING_DEPOT, "Guilda de carroceiros" },
    {TR_BUILDING_DEPOT_DESC, "A guilda de carroceiros envia carroças para transferir bens entre os armazéns e celeiros, de acordo com o ordenado. As carroças devem retornar à guilda após cada entrega." },
    {TR_BUILDING_DEPOT_FEW_EMPLOYEES, "Com quase nenhum funcionário, ninguém sequer se lembra quando a última carroça foi enviada." },
    {TR_BUILDING_DEPOT_HALF_EMPLOYEES, "Essa guilda tem poucos trabalhadores, por isso o transporte de produtos está lento." },
    {TR_BUILDING_DEPOT_MANY_EMPLOYEES, "Essa guilda trabalha abaixo da capacidade máxima. Os recursos poderiam ser transportados com mais rapidez se houvesse mais trabalhadores." },
    {TR_BUILDING_DEPOT_NO_EMPLOYEES, "Ninguém trabalha nessa guilda. Vários gatos estão dormindo nas carroças vazias." },
    {TR_BUILDING_DEPOT_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui. O transporte de produtos está bem demorado." },
    {TR_BUILDING_INFO_CARTLOAD, "carga." },
    {TR_BUILDING_INFO_CARTLOADS, "cargas." },
    {TR_BUILDING_INFO_DEPOT_CONDITION, "Quando" },
    {TR_BUILDING_INFO_DEPOT_DELIVER, "Entrega" },
    {TR_BUILDING_INFO_DEPOT_DESTINATION, "Destino" },
    {TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE, "Sem destino disponível" },
    {TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE, "Sem fornecedor disponível" },
    {TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE, "Apenas uma construção disponível" },
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION, "Selecionar destino" },
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE, "Selecionar estoque de destino" },
    {TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE, "Selecionar recurso" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE, "Selecionar fornecedor" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE, "Selecionar estoque do fornecedor" },
    {TR_BUILDING_INFO_DEPOT_SOURCE, "Fornecedor" },
    {TR_BUILDING_INFO_MOTHBALL_WARNING, "Este edifício está fechado." },
    {TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC, "A construção deste mausoléu requer materiais vindos de um armazém, trabalhadores de um campo de trabalho, e arquitetos de uma guilda de arquitetura." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1, "Câmara" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT, "Os pedreiros estão alinhando pedras esculpidas com precisão para elevar a câmara central deste mausoléu." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2, "Fachada" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT, "Hábeis artesãos estão trabalhando na fachada desse mausoléu, esculpindo estátuas de mármore reluzente, para imortalizar aqueles que descansarem aqui." },
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE, "Portão circular de jardim" },
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC, "Este portão controla a circulação de pessoas para dentro e fora dos locais mais isolados da cidade." },
    {TR_BUILDING_PANELLED_GARDEN_WALL, "Muro de jardim com painéis" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE, "Portão de muro de jardim com painéis" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC, "Este portão controla a circulação de pessoas para dentro e fora dos locais mais isolados da cidade." },
    {TR_BUILDING_SAND_PIT, "Mina de areia" },
    {TR_BUILDING_SAND_PIT_COMPLETE, "completo." },
    {TR_BUILDING_SAND_PIT_DESC, "Minera areia para a construção de monumentos." },
    {TR_BUILDING_SAND_PIT_FEW_EMPLOYEES, "Quase sem trabalhadores, essa mina está com o seu funcionamento praticamente interrompido e pouca areia será extraída ao longo do ano." },
    {TR_BUILDING_SAND_PIT_FULL_EMPLOYEES, "Essa mina tem todos os funcionários de que necessita. A extração de areia vai de vento em popa." },
    {TR_BUILDING_SAND_PIT_HALF_EMPLOYEES, "Essa mina precisa de mais trabalhadores. A extração de areia está levando mais tempo do que o normal." },
    {TR_BUILDING_SAND_PIT_HALTED, "O Conselheiro do Comércio ordenou a suspensão da extração de areia." },
    {TR_BUILDING_SAND_PIT_MANY_EMPLOYEES, "Essa mina está trabalhando abaixo de sua capacidade máxima. A extração de areia seria mais rápida se houvesse mais trabalhadores." },
    {TR_BUILDING_SAND_PIT_NO_EMPLOYEES, "Essa mina está sem trabalhadores. Nenhum grão de areia será extraído." },
    {TR_BUILDING_SAND_PIT_PRODUCTION, "A produção está" },
    {TR_BUILDING_SAND_PIT_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso a extração de areia está bem lenta." },
    {TR_BUILDING_STONE_QUARRY, "Pedreira" },
    {TR_BUILDING_STONE_QUARRY_COMPLETE, "completo." },
    {TR_BUILDING_STONE_QUARRY_DESC, "Minera pedras para a construção de monumentos." },
    {TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES, "Quase sem trabalhadores, essa pedreira está com o seu funcionamento praticamente interrompido e poucas pedras serão extraídas ao longo do ano."},
    {TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES, "Essa pedreira tem todos os funcionários de que necessita. A extração de pedras vai de vento em popa."},
    {TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES, "Essa pedreira precisa de mais trabalhadores. A extração de pedras está levando mais tempo do que o normal."},
    {TR_BUILDING_STONE_QUARRY_HALTED, "O Conselheiro do Comércio ordenou a suspensão da extração de pedras."},
    {TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES, "Essa pedreira está trabalhando abaixo de sua capacidade máxima. A extração de pedras seria mais rápida se houvesse mais trabalhadores."},
    {TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES, "Essa pedreira está sem trabalhadores. Nenhuma pedra será extraída."},
    {TR_BUILDING_STONE_QUARRY_PRODUCTION, "A produção está"},
    {TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES, "Pouquíssimas pessoas trabalham aqui, por isso a extração de pedras está bem lenta."},
    {TR_BUILDING_WINDOW_INDUSTRY_NEEDED, " requerido)" },
    {TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE, "O preço para a bertura de rota comercial mudou." },
    {TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE, "Preço da rota comercial" },
    {TR_CITY_WARNING_BUILD_SAND_PIT, "Constrói uma mina de areia"},
    {TR_CITY_WARNING_BUILD_STONE_QUARRY, "Constrói uma pedreira"},
    {TR_CITY_WARNING_SAND_NEEDED, "Esse edifício precisa de areia"},
    {TR_CITY_WARNING_STONE_NEEDED, "Esse edifício precisa de pedra"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE, "Ativar soma de construções do tipo"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ANY, "Soma de construções do tipo"},
    {TR_CONDITION_TYPE_CITY_POPULATION, "População da cidade"},
    {TR_CONDITION_TYPE_COUNT_OWN_TROOPS, "Soma de tropas"},
    {TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK, "Valor de variável personalizada"},
    {TR_CONDITION_TYPE_DIFFICULTY, "Dificuldade"},
    {TR_CONDITION_TYPE_MONEY, "Fundos da cidade"},
    {TR_CONDITION_TYPE_POPS_UNEMPLOYMENT, "Desemprego"},
    {TR_CONDITION_TYPE_REQUEST_IS_ONGOING, "Solicitação ativa"},
    {TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE, "Estoque disponível do recurso"},
    {TR_CONDITION_TYPE_RESOURCE_STORED_COUNT, "Total do recurso estocado"},
    {TR_CONDITION_TYPE_ROME_WAGES, "Salários pagos por Roma"},
    {TR_CONDITION_TYPE_SAVINGS, "Economias pessoais"},
    {TR_CONDITION_TYPE_STATS_CITY_HEALTH, "Saúde da cidade"},
    {TR_CONDITION_TYPE_STATS_CULTURE, "Cultura"},
    {TR_CONDITION_TYPE_STATS_FAVOR, "Apreço"},
    {TR_CONDITION_TYPE_STATS_PEACE, "Paz"},
    {TR_CONDITION_TYPE_STATS_PROSPERITY, "Prosperidade"},
    {TR_CONDITION_TYPE_TAX_RATE, "Imposto"},
    {TR_CONDITION_TYPE_TIME_PASSED, "Tempo decorrido"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_OPEN, "A rota comercial está aberta"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_PRICE, "Preço de abertura de rota comercial"},
    {TR_CONDITION_TYPE_TRADE_SELL_PRICE, "Preço de venda"},
    {TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE, "Solicitar confirmação para substituir arquivo"},
    {TR_CONFIG_DRAW_CLOUD_SHADOWS, "Desenhar sombras de nuvens"},
    {TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS, "Sincronizar portões não militares para permitir todo tipo de trabalhador"},
    {TR_EDITOR_CHECK_LOG_MESSAGE, "Por favor, confira augustus-log.txt no seu diretório do Augustus para detalhes."},
    {TR_EDITOR_CUSTOM_MESSAGES_CLEAR, "Apagar mensagens" },
    {TR_EDITOR_CUSTOM_MESSAGES_COUNT, "Total de mensagens" },
    {TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL, "Exportar mensagens personalizadas" },
    {TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL, "Importar mensagens personalizadas" },
    {TR_EDITOR_CUSTOM_MESSAGES_TITLE, "Mensagens personalizadas" },
    {TR_EDITOR_CUSTOM_VARIABLES_COUNT, "Máximo de variáveis permitidas" },
    {TR_EDITOR_CUSTOM_VARIABLES_TITLE, "Variáveis personalizadas" },
    {TR_EDITOR_DELETE, "Apagar"},
    {TR_EDITOR_DELETED, "Apagado"},
    {TR_EDITOR_GRID_OFFSET, " posição" },
    {TR_EDITOR_IMPORT_LINE, "Linha: "},
    {TR_EDITOR_SCENARIO_ACTION, "Ação"},
    {TR_EDITOR_SCENARIO_ACTION_ADD, "Adicionar nova ação"},
    {TR_EDITOR_SCENARIO_CONDITION, "Condição"},
    {TR_EDITOR_SCENARIO_CONDITION_ADD, "Adicionar nova condição"},
    {TR_EDITOR_SCENARIO_DESELECT_INTRO, "Desmarcar introdução do cenário"},
    {TR_EDITOR_SCENARIO_EVENTS_ACTIONS, "ações" },
    {TR_EDITOR_SCENARIO_EVENTS_ADD, "Adicionar novo evento"},
    {TR_EDITOR_SCENARIO_EVENTS_CLEAR, "Apagar todos os eventos" },
    {TR_EDITOR_SCENARIO_EVENTS_CONDITIONS, "condições" },
    {TR_EDITOR_SCENARIO_EVENTS_COUNT, "eventos do cenário" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT, "Exportar" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL, "Exportar eventos do cenário" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT, "Importar" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL, "Importar eventos do cenário" },
    {TR_EDITOR_SCENARIO_EVENTS_TITLE, "Eventos do cenário" },
    {TR_EDITOR_SCENARIO_EVENT_DELETED, "Eventos apagados"},
    {TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT, "Não se repete."},
    {TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT, "Número de repetições: "},
    {TR_EDITOR_SCENARIO_EVENT_ID, "ID: "},
    {TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS, "Número máximo de repetições: "},
    {TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE, "Meses até a ativação: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER, "Infinito"},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS, "Máximo de meses até a repetição: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS, "Mínimo de meses até a repetição: "},
    {TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE, "Ativo"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED, "Desativado"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED, "Interrompido"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED, "Indefinido"},
    {TR_EDITOR_SCENARIO_SELECT_INTRO, "Selecionar introdução do cenário"},
    {TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE, "Não foi possível carregar mensagens personalizadas"},
    {TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE, "Não foi possível carregar os eventos do cenário"},
    {TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE, "Não foi possível salvar os eventos do cenário"},
    {TR_FIGURE_INFO_DEPOT_DELIVER, "Entregando " },
    {TR_FIGURE_INFO_DEPOT_FROM, "De " },
    {TR_FIGURE_INFO_DEPOT_RECALL, "Chamar de volta" },
    {TR_FIGURE_INFO_DEPOT_RETURNING, "Voltando" },
    {TR_FIGURE_INFO_DEPOT_TO, " para " },
    {TR_HOTKEY_BUILD_HIGHWAY, "Estrada Imperial"},
    {TR_HOTKEY_RESET_ZOOM, "Resetar zoom"},
    {TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE, "Visão de nativos"},
    {TR_HOTKEY_ZOOM_IN, "Aumentar zoom"},
    {TR_HOTKEY_ZOOM_OUT, "Diminuir zoom"},
    {TR_ORDER_CONDITION_ALWAYS, "Sempre" },
    {TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN, "O destino tem menos de" },
    {TR_ORDER_CONDITION_NEVER, "Nunca" },
    {TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN, "O destino tem mais de" },
    {TR_OVERLAY_STORAGES, "Estoques" },
    {TR_PARAMETER_ADD_AS_BUYING, "Adicionar como compra?"},
    {TR_PARAMETER_ALLOWED, "Permitido?"},
    {TR_PARAMETER_APPLY_COST, "Aplicar o custo de abertura?"},
    {TR_PARAMETER_CHECK_FOR_ONGOING, "Conferir continuidade?"},
    {TR_PARAMETER_CHECK_FOR_OPEN, "Conferir abertura de rota?"},
    {TR_PARAMETER_DESTROY_ALL, "Demolir todos os tipos?"},
    {TR_PARAMETER_DISPLAY_ADD_AS_BUYING, "adicionar como compra"},
    {TR_PARAMETER_DISPLAY_ADD_AS_SELLING, "adicionar como venda"},
    {TR_PARAMETER_DISPLAY_ADD_TO, "adicionar"},
    {TR_PARAMETER_DISPLAY_ALLOWED, "permitido"},
    {TR_PARAMETER_DISPLAY_ANYWHERE, "qualquer local"},
    {TR_PARAMETER_DISPLAY_APPLY_COST, "aplicar custo"},
    {TR_PARAMETER_DISPLAY_BETWEEN, "entre"},
    {TR_PARAMETER_DISPLAY_BUY_PRICE, "preço de compra"},
    {TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES, "demolir todos os tipos"},
    {TR_PARAMETER_DISPLAY_DISALLOWED, "proibido"},
    {TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE, "não mostrar mensagem"},
    {TR_PARAMETER_DISPLAY_FLAT_NUMBER, "número bruto"},
    {TR_PARAMETER_DISPLAY_IGNORE_SETTINGS, "ignorando configurações"},
    {TR_PARAMETER_DISPLAY_IN_CITY, "na cidade"},
    {TR_PARAMETER_DISPLAY_MONTHS, "meses"},
    {TR_PARAMETER_DISPLAY_NOT_ONGOING, "não está ativa"},
    {TR_PARAMETER_DISPLAY_NO_COST, "sem custo"},
    {TR_PARAMETER_DISPLAY_ONGOING, "está ativa"},
    {TR_PARAMETER_DISPLAY_PERCENTAGE, "porcentagem"},
    {TR_PARAMETER_DISPLAY_RESPECT_SETTINGS, "aceitando configurações"},
    {TR_PARAMETER_DISPLAY_ROUTE_CLOSED, "rota fechada"},
    {TR_PARAMETER_DISPLAY_ROUTE_OPEN, "rota aberta"},
    {TR_PARAMETER_DISPLAY_SELL_PRICE, "preço de venda"},
    {TR_PARAMETER_DISPLAY_SET_TO, "definir como"},
    {TR_PARAMETER_DISPLAY_SHOW_MESSAGE, "mostrar mensagem"},
    {TR_PARAMETER_GRID_OFFSET, "Posição da grade"},
    {TR_PARAMETER_IN_CITY_ONLY, "Contar apenas soldados na cidade?"},
    {TR_PARAMETER_PRODUCED, "Produzido?"},
    {TR_PARAMETER_RADIUS, "Raio"},
    {TR_PARAMETER_RESPECT_SETTINGS, "Aceitar confirgurações de estoque?"},
    {TR_PARAMETER_SET_BUY_PRICE, "Definir preço de compra?"},
    {TR_PARAMETER_SET_TO_VALUE, "Definir como valor?"},
    {TR_PARAMETER_SHOW_MESSAGE, "Mostrar mensagem?"},
    {TR_PARAMETER_TYPE_ALLOWED_BUILDING, "Tipo de construção permissível"},
    {TR_PARAMETER_TYPE_BOOLEAN, "Verdadeiro ou Falso"},
    {TR_PARAMETER_TYPE_BUILDING_COUNTING, "Tipo de construção para soma"},
    {TR_PARAMETER_TYPE_CHECK, "Checagem de comparação"},
    {TR_PARAMETER_TYPE_CUSTOM_MESSAGE, "Mensagem personalizada"},
    {TR_PARAMETER_TYPE_CUSTOM_VARIABLE, "Variável personalizada"},
    {TR_PARAMETER_TYPE_DIFFICULTY, "Dificuldade"},
    {TR_PARAMETER_TYPE_FUTURE_CITY, "Apontar futura cidade comercial"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX, "Máximo"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN, "Mínimo"},
    {TR_PARAMETER_TYPE_NUMBER, "Número"},
    {TR_PARAMETER_TYPE_POP_CLASS, "Classe de população"},
    {TR_PARAMETER_TYPE_RATING_TYPE, "Típo de índice"},
    {TR_PARAMETER_TYPE_RESOURCE, "Recurso"},
    {TR_PARAMETER_TYPE_ROUTE, "Apontar rota comercial"},
    {TR_PARAMETER_TYPE_STANDARD_MESSAGE, "Mensagem padrão"},
    {TR_PARAMETER_TYPE_STORAGE_TYPE, "Tipo de estoque"},
    {TR_PARAMETER_USE_PERCENTAGE, "Usar porcentagem?"},
    {TR_PARAMETER_VALUE_BOOLEAN_FALSE, "Falso"},
    {TR_PARAMETER_VALUE_BOOLEAN_TRUE, "Verdadeiro"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES, "Templo grande de Ceres"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS, "Templo grande de Marte"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, "Templo grande de Mercúrio"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE, "Templo grande de Netuno"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS, "Templo grande de Vênus"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_FARMS, "Todas as fazendas"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES, "Todas as residências do governador"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES, "Todos os Santuários"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES, "Todos os templos grandes"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PARKS, "Todos os parques decorativos"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PATHS, "Todos os caminhos decorativos"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS, "Todas as matérias-primas"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES, "Todos os templos pequenos"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_STATUES, "Todas as estátuas"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_TREES, "Todas as árvores decorativas"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS, "Todas as fábricas"},
    {TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS, "Plantações nativas"},
    {TR_PARAMETER_VALUE_BUILDING_NONE, "Nenhum"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES, "Templo pequeno de Ceres"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS, "Templo pequeno de Marte"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY, "Templo pequeno de Mercúrio"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE, "Templo pequeno de Netuno"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS, "Templo pequeno de Vênus"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL, "Igual a"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS, "Menos que ou igual a"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE, "Maior que ou igual a"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN, "Maior que"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN, "Menos que"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL, "Diferente de"},
    {TR_PARAMETER_VALUE_DIFFICULTY_EASY, "Fácil"},
    {TR_PARAMETER_VALUE_DIFFICULTY_HARD, "Difícil"},
    {TR_PARAMETER_VALUE_DIFFICULTY_NORMAL, "Padrão"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY, "Muito fácil"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD, "Muito difícil"},
    {TR_PARAMETER_VALUE_DYNAMIC_RESOLVE, "..."},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND, "Som"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO, "Vídeo"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES, "Bênção de Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS, "Bênção de Marte"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY, "Bênção de Mercúrio"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE, "Bênção alternativa de Mercúrio"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE, "Bênção de Netuno"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE, "Bênção alternativa de Netuno"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS, "Bênção de Vênus"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE, "Bênção alternativa de Vênus"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER, "Ira de Caesar"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE, "Exército de Caesar prossegue"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT, "Exército de Caesar recua"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1, "Respeito de Caesar 1"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2, "Respeito de Caesar 2"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3, "Respeito de Caesar 3"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH, "Fúria de Caesar"},
    {TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET, "Ceres está descontente"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT, "Cidade endividada"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN, "Cidade novamente endividada"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT, "City ainda endividada"},
    {TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER, "Água contaminada"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE, "Batalha distante"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN, "Batalha distante cidade retomada"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS, "Batalha distante perdida (sem tropas)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE, "Batalha distante perdida (atraso)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK, "Batalha distante perdida (insuficiente)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON, "Batalha distante vitoriosa"},
    {TR_PARAMETER_VALUE_MESSAGE_EMIGRATION, "Emigração"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE, "Mudança de Imperador"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED, "Expansão do Império"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR, "Inimigos às portas"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING, "Inimigos se aproximam"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING, "Inimigos recuando"},
    {TR_PARAMETER_VALUE_MESSAGE_FIRED, "Demitido"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT, "Revolta de gladiadores"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED, "Fim da revolta de gladiadores"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY, "Deuses descontentes"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL, "Deuses irados"},
    {TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL, "Festival suntuoso"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE, "Saúde - enfermidade"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS, "Saúde - doenças"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE, "Saúde - peste"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES, "Deslizamentos de terra"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS, "Tempestades de areia"},
    {TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL, "Grande Festival"},
    {TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET, "Marte está descontente"},
    {TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET, "Mercúrio está descontente"},
    {TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET, "Netuno está descontente"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES, "Rome diminui salários"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES, "Rome aumenta salários"},
    {TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED, "Comércio marítimo interrompido"},
    {TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL, "Pequeno festival"},
    {TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING, "Soldados famintos"},
    {TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET, "Vênus está descontente"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES, "Ira de Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS, "Ira de Marte"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY, "Ira de Marte (sem militarismo)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES, "Ira de Marte (sem nativos)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY, "Ira de Mercúrio"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE, "Ira de Netuno"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE, "Ira de Netuno (sem comércio marítimo)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS, "Ira de Vênus"},
    {TR_PARAMETER_VALUE_NONE, "Nenhum"},
    {TR_PARAMETER_VALUE_POP_CLASS_ALL, "Tudo"},
    {TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN, "Patrícios"},
    {TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN, "Plebeus"},
    {TR_PARAMETER_VALUE_POP_CLASS_SLUMS, "Indigentes"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PEACE, "Paz"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY, "Prosperidade"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_ALL, "Tudo"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES, "Celeiros"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES, "Armazéns"},
    {TR_RESOURCE_BRICKS, "Tijolos"},
    {TR_RESOURCE_CONCRETE, "Concreto"},
    {TR_RESOURCE_SAND, "Areia"},
    {TR_RESOURCE_STONE, "Pedra"},
    {TR_SAVE_DIALOG_FILTER, "Filtrar"},
    {TR_SAVE_DIALOG_INVALID_FILE_DESC, "O arquivo selecionado é inválido.\n\nO arquivo pode ter se corrompido devido a um erro.\n\nSe você tem certeza de que este arquivo é válido, por favor reporte o erro em:\n\nhttps://github.com/Keriew/augustus/issues/new\n\nPor favor, anexe o arquivo salvo."},
    {TR_SAVE_DIALOG_NEW_FILE, "Novo arquivo"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE, "Substituir arquivo?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DESC, "O arquivo já existe. Substituir?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN, "Não pergunte de novo"},
    {TR_SAVE_DIALOG_SORTING_BY_DATE, "Organizar por data"},
    {TR_SAVE_DIALOG_SORTING_BY_NAME, "Organizar por nome"},
    {TR_TOOLTIP_BUTTON_CENTER_CAMERA, "Centralizar câmera na construção"},
    {TR_ACTION_TYPE_INVASION_IMMEDIATE, "Inicia a invasão imediatamente" },
    {TR_BUILDING_CARAVANSERAI_NO_FOOD, "Este caravançará tem funcionários, mas eles estão ocupados procurando por um estoque de comida." },
    {TR_BUILDING_INFO_TOTAL_FOOD, "Total de comida:" },
    {TR_BUILDING_MENU_SHRINES, "Altar" },
    {TR_BUILDING_MESS_HALL_NO_FOOD, "Este posto de suprimentos tem funcionários, mas eles estão ocupados procurando por um estoque de comida." },
    {TR_BUILDING_SHRINE_CERES, "Altar de Ceres" },
    {TR_BUILDING_SHRINE_DESC, "Altares são apreciados tanto por sua vizinhança quanto pelos seus respectivos deuses." },
    {TR_BUILDING_SHRINE_MARS, "Altar de Marte" },
    {TR_BUILDING_SHRINE_MERCURY, "Altar de Mercúrio" },
    {TR_BUILDING_SHRINE_NEPTUNE, "Altar de Netuno" },
    {TR_BUILDING_SHRINE_VENUS, "Altar de Vênus" },
    {TR_CONDITION_TYPE_BUILDING_COUNT_AREA, "Edifícios na região" },
    {TR_PARAMETER_DISPLAY_DAYS, "dias" },
    {TR_PARAMETER_TYPE_ENEMY_TYPE, "Tipo de inimigo" },
    {TR_PARAMETER_TYPE_INVASION_POINT, "Ponto de invasão" },
    {TR_PARAMETER_TYPE_INVASION_SIZE, "Tamanho" },
    {TR_PARAMETER_TYPE_INVASION_TYPE, "Tipo de ataque" },
    {TR_PARAMETER_TYPE_TARGET_TYPE, "Tipo de alvo" },
    {TR_PARAMETER_VALUE_BUILDING_ANY, "Qualquer" },
    {TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN, "Bárbaros!" },
    {TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN, "Cartagineses" },
    {TR_PARAMETER_VALUE_ENEMY_11_CAESAR, "Caesar" },
    {TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN, "Númidas" },
    {TR_PARAMETER_VALUE_ENEMY_2_GAUL, "Gauleses" },
    {TR_PARAMETER_VALUE_ENEMY_3_CELT, "Celtas" },
    {TR_PARAMETER_VALUE_ENEMY_4_GOTH, "Godos" },
    {TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM, "Pergamum" },
    {TR_PARAMETER_VALUE_ENEMY_6_SELEUCID, "Selêucidas" },
    {TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN, "Etruscos" },
    {TR_PARAMETER_VALUE_ENEMY_8_GREEK, "Gregos" },
    {TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN, "Egípcios" },
    {TR_PARAMETER_VALUE_ENEMY_UNDEFINED, "Mapa definido" },
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS, "Melhores edifícios" },
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN, "Infraestrutura de alimentos" },
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES, "Reservas de ouro" },
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM, "Aleatório" },
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS, "Tropas" },
    {TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR, "Caesar" },
    {TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY, "Exército inimigo" },
    {TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES, "Nativos de Marte" },
    {TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES, "Nativos" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL, "Arenas" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL, "Tabernas" },

};

void translation_portuguese(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
