#

**Version:** 0.0.24
**Published:** 2024-01-25T22:49:24Z

## Release Notes

📦 **Rust Coreutils 0.0.24 Release:**

We've got +29 more GNU tests passing than in our last release! We are getting closer to version 1.0: each test passed is a step forward in ensuring that our users have a reliable and robust set of utilities that align closely with GNU standards.

49 developers contributed to this release (28 new contributors started with this release).

A key highlight of this release is the expansion of support to new platforms and operating systems. Notably, the software has been ported to sparc64, OpenBSD, and Redox, broadening its usability across different system architectures and environments. This marks a significant step in making Rust Coreutils more versatile and accessible to a wider range of users and developers.

In addition to these expansions, the release has also focused on the integration of more fuzzing techniques, including differential fuzzing and OSS Fuzz integration.

We also contributed to the GNU implementation to improve their test coverage.

We would like to thank to the support the Sovereign Tech Fund for their support (more details later).

Visit our website at [https://uutils.github.io](https://uutils.github.io).

If you want to help us, please consider sponsoring on GitHub. This helps us use better tools like GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

## GNU test suite compatibility

Here's how version 0.0.24 compares to the previous release - running GNU/Coreutils 9.4:

| Result | 0.0.23 | 0.0.24 | Change 0.0.23 to 0.0.24 | % Total 0.0.23 | % Total 0.0.24 | % Change |
|--------|--------|--------|-------------------------|----------------|----------------|----------|
| Pass   | 393    | 422    | +29                     | 65.07%         | 69.87%         | +4.80%   |
| Skip   | 49     | 50     | +1                      | 8.11%          | 8.28%          | +0.17%   |
| Fail   | 160    | 132    | -28                     | 26.49%         | 21.85%         | -4.64%   |
| Error  | 2      | 0      | -2                      | 0.33%          | 0.00%          | -0.33%   |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).


## What's Changed

### cat
* Address cognitive complexity by @jetlime in https://github.com/uutils/coreutils/pull/5726

### cksum
* Stops when one of given files doesn't exist #5809  by @biplab5464 in https://github.com/uutils/coreutils/pull/5820
* Made return an error if the algorithm blake2b is used on a directory. by @Ato2207 in https://github.com/uutils/coreutils/pull/5804
* Add --raw argument by @D9nni in https://github.com/uutils/coreutils/pull/5803
* Made return an error if used on a directory. by @Ato2207 in https://github.com/uutils/coreutils/pull/5822
* Add --length argument for the blake2b algorithm by @DitherWither in https://github.com/uutils/coreutils/pull/5749

### cp
* Improve error msg if -r is not specified by @cakebaker in https://github.com/uutils/coreutils/pull/5555
* Debug with --update=none should show 'skipped' by @sylvestre in https://github.com/uutils/coreutils/pull/5701
* --remove-destination: don't fail if destination is hardlink to source by @cakebaker in https://github.com/uutils/coreutils/pull/5431
* cp/mv/ln: add support for the "will not overwrite just-created" by @sylvestre in https://github.com/uutils/coreutils/pull/5699
* --link: don't fail if destination is hardlink to source by @cakebaker in https://github.com/uutils/coreutils/pull/5484
* Fix backup of destination symlink by @cakebaker in https://github.com/uutils/coreutils/pull/5731
* Update a GNU test error check -  tests/fail-perm.sh by @sylvestre in https://github.com/uutils/coreutils/pull/5784
* cp/mv: manage with trailing slash in target by @sylvestre in https://github.com/uutils/coreutils/pull/5780
* Show no "same file" error for `--link a a` by @cakebaker in https://github.com/uutils/coreutils/pull/5762
* Backup dest symlink linking to source by @cakebaker in https://github.com/uutils/coreutils/pull/5739
* --preserve should keep xattr by @sylvestre in https://github.com/uutils/coreutils/pull/5834
* Remove the tests/link-heap.sh workaround by @sylvestre in https://github.com/uutils/coreutils/pull/5800
* Show error if source and destination are same file by @cakebaker in https://github.com/uutils/coreutils/pull/5757
* Disable a test failing on freebsd by @sylvestre in https://github.com/uutils/coreutils/pull/5750
* Adapt warning if source is used more than once by @cakebaker in https://github.com/uutils/coreutils/pull/5745
* tests, tests/test: Don't attempt to set sticky file bit on FreeBSD by @n1000 in https://github.com/uutils/coreutils/pull/5602

### dd
* Buffer partial blocks in the output writer by @jfinkels in https://github.com/uutils/coreutils/pull/4545
* Skip two tests without "printf" feature by @cakebaker in https://github.com/uutils/coreutils/pull/5607
* /chroot: improve the skip message (not root) by @sylvestre in https://github.com/uutils/coreutils/pull/5734

### df
* Fix rounding issue in test by @cakebaker in https://github.com/uutils/coreutils/pull/5532

### dircolors
* Move the static long string into structures.  by @sylvestre in https://github.com/uutils/coreutils/pull/5611

### du
* Start printing output immediately by @ceteece in https://github.com/uutils/coreutils/pull/5552
* Disable test on Android by @cakebaker in https://github.com/uutils/coreutils/pull/5615
* Cleanup by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5623
* Fix issue with dereference in test by @cakebaker in https://github.com/uutils/coreutils/pull/5625
* Test behavior with POSIXLY_CORRECT set by @cakebaker in https://github.com/uutils/coreutils/pull/5530
* Call unused _du_basics() in test_du_basics() by @cakebaker in https://github.com/uutils/coreutils/pull/5503
* Implement files0-from by @sylvestre in https://github.com/uutils/coreutils/pull/5721
* Simplify file creation in tests by @cakebaker in https://github.com/uutils/coreutils/pull/5727
* Show error for nul names with `--files0-from` by @cakebaker in https://github.com/uutils/coreutils/pull/5772
* Ignore duplicate names with `--files0-from` by @cakebaker in https://github.com/uutils/coreutils/pull/5775

### echo
* Make `-e` and `-E` override each other by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5635

### expand
* Fix duplicate flags by @allaboutevemirolive in https://github.com/uutils/coreutils/pull/5684

### expr
* Check prefix operation by @Luv-Ray in https://github.com/uutils/coreutils/pull/5566
* Different stderr with `"56" "substr"` by @pawelngei in https://github.com/uutils/coreutils/pull/5559
* Adapt error messages, revert most of #5559 by @cakebaker in https://github.com/uutils/coreutils/pull/5578
* Refactor AST and parsing by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5586
* Fix issue 5576 (regex matching bug) by @cobaweel in https://github.com/uutils/coreutils/pull/5577
* Optimizing for integer values by @Arp-1 in https://github.com/uutils/coreutils/pull/5614
* Coerce to string before comparing values by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5673

### fmt
* A collection of small refactors by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5592
* Rename `pfxind_end` -> `prefix_indent_end` by @cakebaker in https://github.com/uutils/coreutils/pull/5593
* Remove crash! macro by @Arp-1 in https://github.com/uutils/coreutils/pull/5589

### hashsum
* Remove usage of crash! macro by @GDYendell in https://github.com/uutils/coreutils/pull/5581
* When the filename contains some special chars, escape them by @sylvestre in https://github.com/uutils/coreutils/pull/5865

### head
* -c allocate memory as needed by @sylvestre in https://github.com/uutils/coreutils/pull/5704
* head_backwards for non-seekable files like /proc/* or fifos (named pipes) by @cre4ture in https://github.com/uutils/coreutils/pull/5732
* Disable some tests on Android by @cakebaker in https://github.com/uutils/coreutils/pull/5813
* Fix clippy warnings in tests by @cakebaker in https://github.com/uutils/coreutils/pull/5838

### hostname
* tests/hostname: disable failing test_hostname::test_hostname_ip on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/5639

### install
* Fix strip program stdout and destination hyphen handling #5718 by @cre4ture in https://github.com/uutils/coreutils/pull/5848
* Support when a hyphen is passed by @sylvestre in https://github.com/uutils/coreutils/pull/5697
* With -t, check if we aren't passed a file by @sylvestre in https://github.com/uutils/coreutils/pull/5686
* Manages permissions when run as root by @sylvestre in https://github.com/uutils/coreutils/pull/5735
* Remove / from end of path if it exists so as not to mess with .exists() by @mtimaN in https://github.com/uutils/coreutils/pull/5730
* Remove a debug artifact by @sylvestre in https://github.com/uutils/coreutils/pull/5719

### join
* Remove crash! macro by @cswn in https://github.com/uutils/coreutils/pull/5540

### ls
* Remove "#[allow(unused_variables)]" by @cakebaker in https://github.com/uutils/coreutils/pull/5617
* Ignore value of `POSIXLY_CORRECT` by @cakebaker in https://github.com/uutils/coreutils/pull/5609
* Implement --hyperlink by @cakebaker in https://github.com/uutils/coreutils/pull/5622
* Improve the access to metadata of the files by @sylvestre in https://github.com/uutils/coreutils/pull/5660
* Set correct block size when -k is provided by @cakebaker in https://github.com/uutils/coreutils/pull/5700
* Fix padding of size column when using `-l` by @cakebaker in https://github.com/uutils/coreutils/pull/5604
* Match the gnu behavior for colors by @sylvestre in https://github.com/uutils/coreutils/pull/5603
* Set default quoting style to literal when not TTY by @RenjiSann in https://github.com/uutils/coreutils/pull/5553
* Handle invalid block size as GNU does by @cakebaker in https://github.com/uutils/coreutils/pull/5626
* Use show_dir_name to output dir name by @cakebaker in https://github.com/uutils/coreutils/pull/5634
* Make --block-size and --human-readable/--si override each other by @cakebaker in https://github.com/uutils/coreutils/pull/5641
* Manages the COLOR and COLORTERM variables by @sylvestre in https://github.com/uutils/coreutils/pull/5656
* Encode path when using --hyperlink by @cakebaker in https://github.com/uutils/coreutils/pull/5629
* Support hyperlinks for dir names by @cakebaker in https://github.com/uutils/coreutils/pull/5672
* Rename `display_file_name` to `display_item_name` by @cakebaker in https://github.com/uutils/coreutils/pull/5675
* Ignore invalid block size from env vars by @cakebaker in https://github.com/uutils/coreutils/pull/5674
* Recognize BLOCKSIZE env var by @cakebaker in https://github.com/uutils/coreutils/pull/5677
* Remove condition with unreachable "else" block by @cakebaker in https://github.com/uutils/coreutils/pull/5687
* Introduce 2nd blocksize & fix todos in tests by @cakebaker in https://github.com/uutils/coreutils/pull/5693
* Unquoted names should be indented with a space if there is a quoted name by @mtimaN in https://github.com/uutils/coreutils/pull/5740
* Support QUOTING_STYLE environment variable by @RenjiSann in https://github.com/uutils/coreutils/pull/5778
* If acl are used, show the + in the perms by @sylvestre in https://github.com/uutils/coreutils/pull/5816
* /gnu: ignore the libcap check by @sylvestre in https://github.com/uutils/coreutils/pull/5743

### mknod
* Remove `parsemode.rs` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5651
* `mknod`: remove `parsemode.rs` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5651

### mv
* Preserve the xattr by @sylvestre in https://github.com/uutils/coreutils/pull/5835
* Allow destination with slash when using --update by @cakebaker in https://github.com/uutils/coreutils/pull/5695
* Fix issue with -T and destination ending with "/" by @cakebaker in https://github.com/uutils/coreutils/pull/5554
* Rename two tests by @cakebaker in https://github.com/uutils/coreutils/pull/5645
* Simplify condition by @cakebaker in https://github.com/uutils/coreutils/pull/5764
* Fix subdir detection by @cakebaker in https://github.com/uutils/coreutils/pull/5483
* Dir2dir: adjust GNU tests - our error message is better by @sylvestre in https://github.com/uutils/coreutils/pull/5685

### nl
* Don't exit if input is directory by @cakebaker in https://github.com/uutils/coreutils/pull/5806

### pathchk
* Simplify and rename test by @cakebaker in https://github.com/uutils/coreutils/pull/5818

### printf
* Rewrite (with a lot of `seq` changes) by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5128
* Fix hex alternate zero by @spineki in https://github.com/uutils/coreutils/pull/5811
* Use 0 instead of 0o as octal prefix by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5808
* Compatibility by @samueltardieu in https://github.com/uutils/coreutils/pull/5783
* Output of double-quote should not be escaped by @samueltardieu in https://github.com/uutils/coreutils/pull/5828
* %c prints the first byte of its argument by @samueltardieu in https://github.com/uutils/coreutils/pull/5827
* No infinite loop by @sudhackar in https://github.com/uutils/coreutils/pull/5830
* Fixing incorrect exit code when passing invalid value to %x by @pawelngei in https://github.com/uutils/coreutils/pull/5543

### rm
* Improve the code a tiny bit by @sylvestre in https://github.com/uutils/coreutils/pull/5755

### runcon
* Remove trailing '.' by @sylvestre in https://github.com/uutils/coreutils/pull/5702

### seq
* Adjust some error messages. GNU's are better by @sylvestre in https://github.com/uutils/coreutils/pull/5798
* Fix output by @samueltardieu in https://github.com/uutils/coreutils/pull/5789
* Workaround https://github.com/uutils/coreutils/issues/5766 by @sylvestre in https://github.com/uutils/coreutils/pull/5770
* Handle the error when stdout is full by @sylvestre in https://github.com/uutils/coreutils/pull/5765

### shred
* Improve some output to match GNU's by @sylvestre in https://github.com/uutils/coreutils/pull/5712
* Implemented "--remove" arg by @Statheres in https://github.com/uutils/coreutils/pull/5790

### sort
* Allow `-f` to be pass multiple time by @just1602 in https://github.com/uutils/coreutils/pull/5681
* `test/sort`: run cargo fmt by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5689

### split
* Pass GNU test l-chunk by @zhitkoff in https://github.com/uutils/coreutils/pull/5567
* Pass GNU tests/b-chunk.sh by @zhitkoff in https://github.com/uutils/coreutils/pull/5475
* Passing GNU test r-chunk.sh by @zhitkoff in https://github.com/uutils/coreutils/pull/5580
* Remove crash macro by @cswn in https://github.com/uutils/coreutils/pull/5533

### stdbuf
* Remove crash macro by @cswn in https://github.com/uutils/coreutils/pull/5549
* libstdbuf: remove crash macro by @cswn in https://github.com/uutils/coreutils/pull/5565

### tail
* Transform FAIL into ERROR for tests/tail/inotify-rotate-resources.sh by @sylvestre in https://github.com/uutils/coreutils/pull/5771

### tee
* Test: fix a warning on not(linux) by @sylvestre in https://github.com/uutils/coreutils/pull/5723

### test
* tests/test: Ensure the test fixture files have the expected gid by @n1000 in https://github.com/uutils/coreutils/pull/5455
* Use clearer expression for CI testing by @samueltardieu in https://github.com/uutils/coreutils/pull/5769

### tr
* Operate on bytes instead of chars by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5640
* uucore: remove useless conversion for features/fs on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/5676

### tsort
* Returns error when input is dir - same as GNU tsort by @SaHHiiLL in https://github.com/uutils/coreutils/pull/5860

### unexpand
* Remove crash! macro by @allaboutevemirolive in https://github.com/uutils/coreutils/pull/5588
* Should allow multiple files #5852 and show error message if a directory is specified #5845 by @biplab5464 in https://github.com/uutils/coreutils/pull/5864

### wc
* Pass GNU test wc-files0-from.pl by @zhitkoff in https://github.com/uutils/coreutils/pull/5582
* Fix arguments not overriding by @Yykz in https://github.com/uutils/coreutils/pull/5671
* Disable part of test on Android by @cakebaker in https://github.com/uutils/coreutils/pull/5717
* Pass GNU test wc-proc and Windows optimization by @zhitkoff in https://github.com/uutils/coreutils/pull/5612



### Other OS & arch changes
* tests: disable tests for tools unsupported on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/5863
* uucore: add support for sparc64 by @ffontaine in https://github.com/uutils/coreutils/pull/5799
* Fix build on Redox, and add `stat` to Redox feature by @ids1024 in https://github.com/uutils/coreutils/pull/5502
* Add support in uucore for OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/5599
* Fix util shell scripts to be compatible with BSD by @lcheylus in https://github.com/uutils/coreutils/pull/5774
* Support unix feature on OpenBSD (utmpx not supported) by @lcheylus in https://github.com/uutils/coreutils/pull/5620

### CI
* ci: set -no-window in Android workflow by @cakebaker in https://github.com/uutils/coreutils/pull/5814
* CI: test `uucore` with `coreutils` in codecov to run it with the proper features by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5825
* ignore-intermittent.txt: adjust the renamed test name by @sylvestre in https://github.com/uutils/coreutils/pull/5654
* publishing: check if the current version is already there or not by @sylvestre in https://github.com/uutils/coreutils/pull/5535
* Improve the GNU ci analysis: display the root test changes too by @sylvestre in https://github.com/uutils/coreutils/pull/5728
* ci: add aarch64-unknown-linux-musl release artifact by @malt3 in https://github.com/uutils/coreutils/pull/5694
* ci: fix warnings from "cargo tree" by @cakebaker in https://github.com/uutils/coreutils/pull/5670
* ci: rename test summary names for busybox & toybox by @cakebaker in https://github.com/uutils/coreutils/pull/5652
* Add nushell dependency analysis script by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5051
* gnu compare: try to use a local copy if the download failed by @sylvestre in https://github.com/uutils/coreutils/pull/5779
* prevent CI creating 2 events on each pull request push by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/5608
* GNU: Improve the built by @sylvestre in https://github.com/uutils/coreutils/pull/5756
* remaining-gnu-error.py: shows when a test requires root by @sylvestre in https://github.com/uutils/coreutils/pull/5773
* gnu: Improve the diff when comparing diff by @sylvestre in https://github.com/uutils/coreutils/pull/5722
* Add Redox OS CI by @jackpot51 in https://github.com/uutils/coreutils/pull/5642
* build-gnu.sh: build in debug by default. Easier for local dev by @sylvestre in https://github.com/uutils/coreutils/pull/5659
* Fsext refactor by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5680

### Documentation
* docs: fix URL for FreeBSD port by @lcheylus in https://github.com/uutils/coreutils/pull/5763
* doc: Fix a broken link by @YDX-2147483647 in https://github.com/uutils/coreutils/pull/5547
* docs: add winget installer by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5648
* docs: remove scoop badge, adapt links to repos by @cakebaker in https://github.com/uutils/coreutils/pull/5650
* uuhelp_parser: add links to homepage and repo by @michel-slm in https://github.com/uutils/coreutils/pull/5796
* src: Fixing typos in signatures for the argument parser by @dvalere in https://github.com/uutils/coreutils/pull/5696
* Fix typo in signals.rs by @eltociear in https://github.com/uutils/coreutils/pull/5781
* Fix docs issues. by @Ato2207 in https://github.com/uutils/coreutils/pull/5747
* doc: Fix the markdown highlighting syntax by @YDX-2147483647 in https://github.com/uutils/coreutils/pull/5539
* docs: remove two notes by @cakebaker in https://github.com/uutils/coreutils/pull/5657

### Security
* fuzzing: print the diff in case of issue by @sylvestre in https://github.com/uutils/coreutils/pull/5866
* fuzz printf by @sylvestre in https://github.com/uutils/coreutils/pull/5556
* fuzzing: add a variable to state if we know it fails or not by @sylvestre in https://github.com/uutils/coreutils/pull/5563
* fuzz: Simplify the compare_result function by @sylvestre in https://github.com/uutils/coreutils/pull/5662
* fuzzing: quick timeout because seq is freezing by @sylvestre in https://github.com/uutils/coreutils/pull/5636
* Fuzz the echo command by @sylvestre in https://github.com/uutils/coreutils/pull/5600
* fuzz seq by @sylvestre in https://github.com/uutils/coreutils/pull/5621
* expr fuzz: add missing ops. found thanks to oss fuzz coverage by @sylvestre in https://github.com/uutils/coreutils/pull/5557
* fuzz: add the capability to pipe info into fuzz by @sylvestre in https://github.com/uutils/coreutils/pull/5668
* Disable fuzzing seq until issue #5724 is fixed by @sylvestre in https://github.com/uutils/coreutils/pull/5725
* fuzz: use thread to bypass the limitation of output by @sylvestre in https://github.com/uutils/coreutils/pull/5758
* Add new fuzzers: cut, sort, split and wc  by @sylvestre in https://github.com/uutils/coreutils/pull/5760
* fuzz: reset the exit code global variable after every test by @samueltardieu in https://github.com/uutils/coreutils/pull/5782
* fuzz: fix file descriptor leak by @samueltardieu in https://github.com/uutils/coreutils/pull/5787
* fuzz: with pipe, also capture stderr by @sylvestre in https://github.com/uutils/coreutils/pull/5832



### Various improvements
* 0.0.23 => 0.0.24 by @sylvestre in https://github.com/uutils/coreutils/pull/5752
* uuhelp_parser: include missing LICENSE by @daissi in https://github.com/uutils/coreutils/pull/5594
* clippy: fix warnings introduced by Rust 1.75 by @cakebaker in https://github.com/uutils/coreutils/pull/5742
* uucore: fix style in tests by @samueltardieu in https://github.com/uutils/coreutils/pull/5786
* uucore: fix clippy warning from if_not_else lint by @cakebaker in https://github.com/uutils/coreutils/pull/5842
* Handle better some errors by @sylvestre in https://github.com/uutils/coreutils/pull/5791
* Cargo.toml: fix typo by @cakebaker in https://github.com/uutils/coreutils/pull/5564
* META bug: moved to project mgmt by @tdelmas in https://github.com/uutils/coreutils/pull/5776
* use our getegid & geteuid wrappers function instead of libc calls by @sylvestre in https://github.com/uutils/coreutils/pull/5733
* update of the license file to make it generic by @sylvestre in https://github.com/uutils/coreutils/pull/5545
* clippy: fix warnings introduced by Rust 1.74 by @cakebaker in https://github.com/uutils/coreutils/pull/5548
* add missing features to uucore by @sylvestre in https://github.com/uutils/coreutils/pull/5537
* all: remove `collect_{lossy,ignore}` calls where possible by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5649
* fix two minor clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/5655

### dependency updates
* chore(deps): update rust crate itertools to 0.12.0 by @renovate in https://github.com/uutils/coreutils/pull/5534
* fix(deps): update rust crate data-encoding to 2.5 by @renovate in https://github.com/uutils/coreutils/pull/5569
* fix(deps): update rust crate data-encoding-macro to 0.1.14 by @renovate in https://github.com/uutils/coreutils/pull/5568
* chore(deps): update rust crate chrono to ^0.4.32 by @renovate in https://github.com/uutils/coreutils/pull/5870
* chore(deps): update actions/cache action to v4 by @renovate in https://github.com/uutils/coreutils/pull/5856
* chore(deps): update rust crate smallvec to 1.13 by @renovate in https://github.com/uutils/coreutils/pull/5862
* chore(deps): update davidanson/markdownlint-cli2-action action to v15 by @renovate in https://github.com/uutils/coreutils/pull/5859
* chore(deps): update rust crate xattr to 1.3.1 by @renovate in https://github.com/uutils/coreutils/pull/5841
* Bump console and mio by @cakebaker in https://github.com/uutils/coreutils/pull/5824
* chore(deps): update rust crate smallvec to 1.12 by @renovate in https://github.com/uutils/coreutils/pull/5836
* chore(deps): update rust crate tempfile to 3.9.0 by @renovate in https://github.com/uutils/coreutils/pull/5736
* chore(deps): update vmactions/freebsd-vm action to v1.0.3 by @renovate in https://github.com/uutils/coreutils/pull/5509
* chore(deps): update rust crate libc to 0.2.152 by @renovate in https://github.com/uutils/coreutils/pull/5802
* chore(deps): update rust crate bstr to 1.9 by @renovate in https://github.com/uutils/coreutils/pull/5744
* chore(deps): update rust crate self_cell to 1.0.3 by @renovate in https://github.com/uutils/coreutils/pull/5683
* Bump xattr from 1.1.1 to 1.1.3 & adapt deny.toml by @cakebaker in https://github.com/uutils/coreutils/pull/5637
* chore(deps): update rust crate once_cell to 1.19.0 by @renovate in https://github.com/uutils/coreutils/pull/5624
* chore(deps): update vmactions/freebsd-vm action to v1.0.4 by @renovate in https://github.com/uutils/coreutils/pull/5618
* chore(deps): update davidanson/markdownlint-cli2-action action to v14 by @renovate in https://github.com/uutils/coreutils/pull/5583
* chore(deps): update rust crate xattr to 1.1.1 by @renovate in https://github.com/uutils/coreutils/pull/5628
* chore(deps): update vmactions/freebsd-vm action to v1.0.5 by @renovate in https://github.com/uutils/coreutils/pull/5630
* chore(deps): update dependency ubuntu to v22 by @renovate in https://github.com/uutils/coreutils/pull/5142
* chore(deps): update rust crate xattr to 1.2.0 by @renovate in https://github.com/uutils/coreutils/pull/5741
* chore(deps): update rust crate libc to 0.2.151 by @renovate in https://github.com/uutils/coreutils/pull/5633
* chore(deps): update rust crate regex to 1.10.3 by @renovate in https://github.com/uutils/coreutils/pull/5867
* Bump redox_syscall to 0.4.1 by @cakebaker in https://github.com/uutils/coreutils/pull/5658
* chore(deps): update actions/upload-artifact action to v4 by @renovate in https://github.com/uutils/coreutils/pull/5646
* chore(deps): update dawidd6/action-download-artifact action to v3 by @renovate in https://github.com/uutils/coreutils/pull/5644
* chore(deps): update rust crate lscolors to 0.16.0 by @renovate in https://github.com/uutils/coreutils/pull/5601
* Bump freebsd-vm action to v1.0.2 & use ubuntu by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/5606
* Bump crossbeam crates by @cakebaker in https://github.com/uutils/coreutils/pull/5716

## New Contributors
* @cswn made their first contribution in https://github.com/uutils/coreutils/pull/5533
* @YDX-2147483647 made their first contribution in https://github.com/uutils/coreutils/pull/5539
* @pawelngei made their first contribution in https://github.com/uutils/coreutils/pull/5543
* @zoze0 made their first contribution in https://github.com/uutils/coreutils/pull/5574
* @cobaweel made their first contribution in https://github.com/uutils/coreutils/pull/5577
* @GDYendell made their first contribution in https://github.com/uutils/coreutils/pull/5581
* @lcheylus made their first contribution in https://github.com/uutils/coreutils/pull/5599
* @RenjiSann made their first contribution in https://github.com/uutils/coreutils/pull/5553
* @Arp-1 made their first contribution in https://github.com/uutils/coreutils/pull/5614
* @allaboutevemirolive made their first contribution in https://github.com/uutils/coreutils/pull/5588
* @Yykz made their first contribution in https://github.com/uutils/coreutils/pull/5671
* @just1602 made their first contribution in https://github.com/uutils/coreutils/pull/5681
* @malt3 made their first contribution in https://github.com/uutils/coreutils/pull/5694
* @jetlime made their first contribution in https://github.com/uutils/coreutils/pull/5726
* @mtimaN made their first contribution in https://github.com/uutils/coreutils/pull/5730
* @dvalere made their first contribution in https://github.com/uutils/coreutils/pull/5696
* @DitherWither made their first contribution in https://github.com/uutils/coreutils/pull/5749
* @Ato2207 made their first contribution in https://github.com/uutils/coreutils/pull/5747
* @tdelmas made their first contribution in https://github.com/uutils/coreutils/pull/5776
* @cre4ture made their first contribution in https://github.com/uutils/coreutils/pull/5732
* @eltociear made their first contribution in https://github.com/uutils/coreutils/pull/5781
* @michel-slm made their first contribution in https://github.com/uutils/coreutils/pull/5796
* @ffontaine made their first contribution in https://github.com/uutils/coreutils/pull/5799
* @D9nni made their first contribution in https://github.com/uutils/coreutils/pull/5803
* @sudhackar made their first contribution in https://github.com/uutils/coreutils/pull/5830
* @biplab5464 made their first contribution in https://github.com/uutils/coreutils/pull/5820
* @SaHHiiLL made their first contribution in https://github.com/uutils/coreutils/pull/5860

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.23...0.0.24
