use sql;

DATABASE ReturningTest {
	TABLE returnTest(
		id INTEGER PRIMARY KEY,
		a INTEGER,
		b TEXT,
		e TEXT DEFAULT "abc");
}

void returning() {
	MariaDB db(Host:local(), null, null, "test");
	// SQLite db;

	ReturningTest r(db);
	WITH r {
		Int key = 20;
		Str newVal = "updated";

		INSERT INTO returnTest(a, b) VALUES (key, "c");

		if (row = INSERT INTO returnTest(a, b) VALUES (key, "d") RETURNING *) {
			print("Insert: ${row}");
		}

		for (row in UPDATE returnTest SET b = newVal WHERE a = key RETURNING *) {
			print("Update: ${row}");
		}

		for (row in DELETE FROM returnTest WHERE a = key RETURNING *) {
			print("Delete: ${row}");
		}
	}

	// WITH db: INSERT INTO test(b, d) VALUES (20, "a");
	// for (row in WITH db: DELETE FROM test WHERE b = 20 RETURNING *) {
	// 	print(row.toS);
	// }
}
