; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function drelu
; RUN: if [ %llvmver -lt 16 ]; then %opt < %s %loadEnzyme -enzyme -enzyme-preopt=false -mem2reg -early-cse -instcombine -simplifycfg -S | FileCheck %s; fi
; RUN: %opt < %s %newLoadEnzyme -passes="enzyme,function(mem2reg,early-cse,instcombine,%simplifycfg)" -enzyme-preopt=false -S | FileCheck %s

%struct.Gradients = type { double, double }

; Function Attrs: nounwind
declare %struct.Gradients @__enzyme_fwddiff(double (double)*, ...)


define dso_local double @f(double %x) #1 {
entry:
  ret double %x
}

define dso_local double @relu(double %x) {
entry:
  %cmp = fcmp fast ogt double %x, 0.000000e+00
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:                                        ; preds = %entry
  %call = tail call fast double @f(double %x)
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.true
  %cond = phi double [ %call, %cond.true ], [ 0.000000e+00, %entry ]
  ret double %cond
}

define dso_local %struct.Gradients @drelu(double %x) {
;
entry:
  %0 = tail call %struct.Gradients (double (double)*, ...) @__enzyme_fwddiff(double (double)* nonnull @relu, metadata !"enzyme_width", i64 2, double %x, double 0.0, double 1.0)
  ret %struct.Gradients %0
}

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone noinline }

; CHECK: define internal [2 x double] @fwddiffe2relu(double [[X:%.*]], [2 x double] %"x'")
; CHECK: entry:
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast ogt double [[X]], 0.000000e+00
; CHECK-NEXT:    br i1 [[CMP_I]], label [[COND_TRUE_I:%.*]], label [[FWDDIFFE2RELU_EXIT:%.*]]

; CHECK: cond.true:      
; CHECK-NEXT:    [[TMP0:%.*]] = call {{(fast )?}}[2 x double] @fwddiffe2f(double [[X]], [2 x double] %"x'")
; CHECK-NEXT:    [[TMP0_0:%.*]] = extractvalue [2 x double] [[TMP0]], 0
; CHECK-NEXT:    [[TMP0_1:%.*]] = extractvalue [2 x double] [[TMP0]], 1
; CHECK-NEXT:    br label [[FWDDIFFE2RELU_EXIT]]

; CHECK: cond.end: 
; CHECK-NEXT:    [[TMP1_0:%.*]] = phi {{(fast )?}}double [ [[TMP0_0]], [[COND_TRUE_I]] ], [ 0.000000e+00, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1_1:%.*]] = phi {{(fast )?}}double [ [[TMP0_1]], [[COND_TRUE_I]] ], [ 0.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = insertvalue [2 x double] {{(undef|poison)}}, double [[TMP1_0]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = insertvalue [2 x double] [[TMP3]], double [[TMP1_1]], 1
; CHECK-NEXT:  ret [2 x double] [[TMP5]]
; CHECK-NEXT: }
