% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_schemes.r
\name{make_col_scheme}
\alias{make_col_scheme}
\title{Create new sequence logo color scheme}
\usage{
make_col_scheme(
  chars = NULL,
  groups = NULL,
  cols = NULL,
  values = NULL,
  name = ""
)
}
\arguments{
\item{chars}{Vector of one letter characters}

\item{groups}{Vector of groups for letters with same length as chars (optional if cols parameter is provided)}

\item{cols}{Vector of colors with same length as chars (optional if values parameter is provided)}

\item{values}{Vector of numerical values with same length as chars}

\item{name}{Name of color scheme}
}
\description{
Create new sequence logo color scheme
}
\examples{

# Discrete color scheme examples
cs1 = make_col_scheme(chars=c('A', 'T', 'G', 'C'), groups=c('g1', 'g1', 'g2', 'g2'), 
                      cols=c('red', 'red', 'blue', 'blue'), name='custom1')

cs2 = make_col_scheme(chars=c('A', 'T', 'G', 'C'), cols=c('red', 'red', 'blue', 'blue'), 
                      name='custom2')

# Quantitative color scheme
cs3 = make_col_scheme(chars=c('A', 'T', 'G', 'C'), values=1:4, name='custom3')
}
