% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_header_lines}
\alias{add_header_lines}
\title{Add full-width rows to the header}
\usage{
add_header_lines(x, values = character(0), top = TRUE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{values}{a character vector or a call to \code{\link[=as_paragraph]{as_paragraph()}}
to get formated content, each element will
be added as a new row.}

\item{top}{should the row be inserted at the top
or the bottom. Default to TRUE.}
}
\description{
Add one or more rows to the header where each label
spans all columns (all cells merged into one). Useful for adding
titles or subtitles above the column headers.
}
\examples{
# ex 1----
ft_1 <- flextable(head(iris))
ft_1 <- add_header_lines(ft_1, values = "blah blah")
ft_1 <- add_header_lines(ft_1, values = c("blah 1", "blah 2"))
ft_1 <- autofit(ft_1)
ft_1

# ex 2----
ft01 <- fp_text_default(color = "red")
ft02 <- fp_text_default(color = "orange")
ref <- c("(1)", "(2)")
pars <- as_paragraph(
  as_chunk(ref, props = ft02), " ",
  as_chunk(rep("My tailor is rich", length(ref)), props = ft01)
)

ft_2 <- flextable(head(mtcars))
ft_2 <- add_header_lines(ft_2, values = pars, top = FALSE)
ft_2 <- add_header_lines(ft_2, values = ref, top = TRUE)
ft_2 <- add_footer_lines(ft_2, values = "blah", top = TRUE)
ft_2 <- add_footer_lines(ft_2, values = pars, top = TRUE)
ft_2 <- add_footer_lines(ft_2, values = ref, top = FALSE)
ft_2 <- autofit(ft_2)
ft_2
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
