% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{html_code_block}
\alias{html_code_block}
\title{Format Character Vector for Display as Code in HTML}
\usage{
html_code_block(x, class = "fansi-output")
}
\arguments{
\item{x}{character vector}

\item{class}{character vectors of classes to apply to the PRE HTML tags.  It
is the users responsibility to ensure the classes are valid CSS class
names.}
}
\value{
character(1L) \code{x}, with <PRE> and <CODE> HTML tags
applied and collapsed into one line with newlines as the line separator.
}
\description{
This simulates what \code{rmarkdown} / \code{knitr} do to the output of an R markdown
chunk, at least as of \code{rmarkdown} 1.10.  It is useful when we override the
\code{knitr} output hooks so that we can have a result that still looks as if it
was run by \code{knitr}.
}
\examples{
html_code_block(c("hello world"))
html_code_block(c("hello world"), class="pretty")
}
