# Model Bakery: Smart fixtures for better tests

Model Bakery offers you a smart way to create fixtures for testing in Django.

With a simple and powerful API, you can create many objects with a single line of code.

Model Bakery is a rename of the legacy [model_mommy's project](https://pypi.org/project/model_mommy/). This change was made to avoid reinforcing gender stereotypes in technology.
You can read more about this subject [here](https://witi.com/articles/1017/How-Gender-Stereotypes-are-Still-Affecting-Women-in-Tech/).

Documentation: [https://model-bakery.readthedocs.io](https://model-bakery.readthedocs.io)

Source code: [https://github.com/model-bakers/model_bakery/](https://github.com/model-bakers/model_bakery/)

## Key Features

- Automatically generates test data for Django models
- Provides sensible defaults for all field types
- Supports custom field overrides and "recipes" for reusable patterns
- Handles related models and complex relationships
- Works with currently maintained versions of Python and Django

## Installation

```console
$ pip install model-bakery
```

## Contributing to Model Bakery

As an open-source project, Model Bakery welcomes contributions of many forms:

- Code patches
- Documentation improvements
- Bug reports

Take a look at our [GitHub repo](https://github.com/model-bakers/model_bakery/blob/main/CONTRIBUTING.md) for instructions
on how to set up your local environment.

## Support

Feel free to [open an issue](https://github.com/model-bakers/model_bakery/issues/new) for support, development ideas, or questions!

## License

Model Bakery is licensed under the MIT License.
See the [LICENSE](https://github.com/model-bakers/model_bakery/blob/main/LICENSE) file for more information.

## Contents

```{toctree}
:maxdepth: 4

basic_usage
recipes
how_bakery_behaves
test_runners
migrating_from_mommy
```
