% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hashCheck.r
\name{hashCheck}
\alias{hashCheck}
\title{hashCheck}
\usage{
hashCheck(..., file, .print. = TRUE, .names. = NULL)
}
\arguments{
\item{...}{a list of objects including data frames, vectors, functions, and all other types of R objects that represent dependencies of a certain calculation}

\item{file}{name of file in which results are stored}

\item{.print.}{set to \code{FALSE} to suppress printing information messages about what has changed}

\item{.names.}{vector of names of original arguments if not calling \code{hashCheck} directly}
}
\value{
a \code{list} with elements \code{result} (the computations), \code{hash} (the new hash), and \code{changed} which details what changed to make computations need to be run
}
\description{
Check for Changes in List of Objects
}
\details{
Given an RDS file name and a list of objects, does the following:
\itemize{
\item makes a vector of hashes, one for each object.  Function objects are run through \code{deparse} so that the environment of the function will not be considered.
\item see if the file exists; if not, return a list with result=NULL, \code{hash} = new vector of hashes, \code{changed='All'}
\item if the file exists, read the file and its hash attribute as \code{prevhash}
\item if \code{prevhash} is not identical to hash:
if \code{.print.=TRUE} (default), print to console a summary of what's changed
return a list with result=NULL, \code{hash} = new hash vector, changed
\item if \code{prevhash = hash}, return a list with result=file object, \code{hash}=new hash,  changed=''
}

Set \code{options(debughash=TRUE)} to trace results in \verb{/tmp/debughash.txt}
}
\author{
Frank Harrell
}
