// Copyright (c) 1997 by Jim Lynch.
// Copyright (c) 2010-2012,2026 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#include <iostream>
#include <sstream>
#include <string>

#include "str-conversions.h"

void readline(std::istream &in, std::string &it)
{
    getline(in, it);
}

int IsSpace(const char theChar)
{
    int result = 0;

    switch(theChar)
    {
        case ' ':
        case '\n':
        case '\t':
        case '\r':
        case '\v':
        case '\f':
            result = 1;
            break;
    }

    return result;
}

void ChopTrailingWhiteSpace(std::string &it)
{
    int n = it.size() - 1;

    while(IsSpace( it[n] ))
        n--;

    it = it.substr(0, n + 1);
}

void ChopQuestionMark(std::string &it)
{
    ChopTrailingWhiteSpace(it);

    if(*(it.end() - 1) == '?')
    {
        it = it.substr(0, it.size() - 1);
        ChopTrailingWhiteSpace(it);
    }
}

std::string progName;
std::string line;

// void ChopQuestionMark(std::string &it)
// void ChopTrailingWhiteSpace(std::string &it)
// int IsSpace(const char theChar)
// void readline(std::istream &in, std::string &it)

int main(int argc, char *argv[])
{
    progName = argv[0];

    std::cout << "I'm reading a line" << std::endl;
    readline(std::cin, line);

    std::cout << "the line I just read was" << std::endl;
    std::cout << '|' << line << '|' << std::endl;

    ChopTrailingWhiteSpace(line);

    std::cout << "the line without trailing spaces" << std::endl;
    std::cout << '|' << line << '|' << std::endl;

    ChopQuestionMark(line);

    std::cout << "the line without the last trailing '?'" << std::endl;
    std::cout << '|' << line << '|' << std::endl;

    std::cout << "===== end of my own functions =====" << std::endl;

    std::cout << "Enter a long:" << std::endl;

    std::string theLongStr;
    long theLong;

    readline(std::cin, theLongStr);
    // will a string be converted automatically to a const char*? No.
    const char *theLongCStr = theLongStr.c_str();
    theLong = CStringToLong(theLongCStr);
    const char *theLongCStr2 = LongToNewCString(theLong);

    std::cout << "the long was " << theLongCStr2 << std::endl;

    char *s1 = MakeCStringCopy(theLongStr);
    char *s2 = MakeCStringCopy(theLongCStr);

    std::ostringstream ss3(theLongStr);

    char *s3 = MakeCStringCopy(ss3);

    std::cout << "s1 was |" << s1 << "|" << std::endl;
    std::cout << "s2 was |" << s2 << "|" << std::endl;
    std::cout << "s3 was |" << s3 << "|" << std::endl;

    delete theLongCStr2; // note!! placement of this seems critical...
    // it can't be right after its last use for some
    // reason

    return 0;
}
//  std::cout << "" << std::endl;
