//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfboolean?language=objc)
#[repr(C)]
pub struct CFBoolean {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFBoolean {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFBoolean"> for CFBoolean {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbooleantrue?language=objc)
    pub static kCFBooleanTrue: Option<&'static CFBoolean>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbooleanfalse?language=objc)
    pub static kCFBooleanFalse: Option<&'static CFBoolean>;
}

unsafe impl ConcreteType for CFBoolean {
    #[doc(alias = "CFBooleanGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBooleanGetTypeID() -> CFTypeID;
        }
        unsafe { CFBooleanGetTypeID() }
    }
}

impl CFBoolean {
    #[doc(alias = "CFBooleanGetValue")]
    #[inline]
    pub fn value(self: &CFBoolean) -> bool {
        extern "C-unwind" {
            fn CFBooleanGetValue(boolean: &CFBoolean) -> Boolean;
        }
        let ret = unsafe { CFBooleanGetValue(self) };
        ret != 0
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumbertype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberType(pub CFIndex);
impl CFNumberType {
    #[doc(alias = "kCFNumberSInt8Type")]
    pub const SInt8Type: Self = Self(1);
    #[doc(alias = "kCFNumberSInt16Type")]
    pub const SInt16Type: Self = Self(2);
    #[doc(alias = "kCFNumberSInt32Type")]
    pub const SInt32Type: Self = Self(3);
    #[doc(alias = "kCFNumberSInt64Type")]
    pub const SInt64Type: Self = Self(4);
    #[doc(alias = "kCFNumberFloat32Type")]
    pub const Float32Type: Self = Self(5);
    #[doc(alias = "kCFNumberFloat64Type")]
    pub const Float64Type: Self = Self(6);
    #[doc(alias = "kCFNumberCharType")]
    pub const CharType: Self = Self(7);
    #[doc(alias = "kCFNumberShortType")]
    pub const ShortType: Self = Self(8);
    #[doc(alias = "kCFNumberIntType")]
    pub const IntType: Self = Self(9);
    #[doc(alias = "kCFNumberLongType")]
    pub const LongType: Self = Self(10);
    #[doc(alias = "kCFNumberLongLongType")]
    pub const LongLongType: Self = Self(11);
    #[doc(alias = "kCFNumberFloatType")]
    pub const FloatType: Self = Self(12);
    #[doc(alias = "kCFNumberDoubleType")]
    pub const DoubleType: Self = Self(13);
    #[doc(alias = "kCFNumberCFIndexType")]
    pub const CFIndexType: Self = Self(14);
    #[doc(alias = "kCFNumberNSIntegerType")]
    pub const NSIntegerType: Self = Self(15);
    #[doc(alias = "kCFNumberCGFloatType")]
    pub const CGFloatType: Self = Self(16);
    #[doc(alias = "kCFNumberMaxType")]
    pub const MaxType: Self = Self(16);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFNumberType {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFNumberType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumber?language=objc)
#[repr(C)]
pub struct CFNumber {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFNumber {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFNumber"> for CFNumber {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberpositiveinfinity?language=objc)
    pub static kCFNumberPositiveInfinity: Option<&'static CFNumber>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumbernegativeinfinity?language=objc)
    pub static kCFNumberNegativeInfinity: Option<&'static CFNumber>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumbernan?language=objc)
    pub static kCFNumberNaN: Option<&'static CFNumber>;
}

unsafe impl ConcreteType for CFNumber {
    #[doc(alias = "CFNumberGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFNumberGetTypeID() -> CFTypeID;
        }
        unsafe { CFNumberGetTypeID() }
    }
}

impl CFNumber {
    #[doc(alias = "CFNumberCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        the_type: CFNumberType,
        value_ptr: *const c_void,
    ) -> Option<CFRetained<CFNumber>> {
        extern "C-unwind" {
            fn CFNumberCreate(
                allocator: Option<&CFAllocator>,
                the_type: CFNumberType,
                value_ptr: *const c_void,
            ) -> Option<NonNull<CFNumber>>;
        }
        let ret = unsafe { CFNumberCreate(allocator, the_type, value_ptr) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFNumberGetType")]
    #[inline]
    pub fn r#type(self: &CFNumber) -> CFNumberType {
        extern "C-unwind" {
            fn CFNumberGetType(number: &CFNumber) -> CFNumberType;
        }
        unsafe { CFNumberGetType(self) }
    }

    #[doc(alias = "CFNumberGetByteSize")]
    #[inline]
    pub fn byte_size(self: &CFNumber) -> CFIndex {
        extern "C-unwind" {
            fn CFNumberGetByteSize(number: &CFNumber) -> CFIndex;
        }
        unsafe { CFNumberGetByteSize(self) }
    }

    #[doc(alias = "CFNumberIsFloatType")]
    #[inline]
    pub fn is_float_type(self: &CFNumber) -> bool {
        extern "C-unwind" {
            fn CFNumberIsFloatType(number: &CFNumber) -> Boolean;
        }
        let ret = unsafe { CFNumberIsFloatType(self) };
        ret != 0
    }

    #[doc(alias = "CFNumberGetValue")]
    #[inline]
    pub unsafe fn value(self: &CFNumber, the_type: CFNumberType, value_ptr: *mut c_void) -> bool {
        extern "C-unwind" {
            fn CFNumberGetValue(
                number: &CFNumber,
                the_type: CFNumberType,
                value_ptr: *mut c_void,
            ) -> Boolean;
        }
        let ret = unsafe { CFNumberGetValue(self, the_type, value_ptr) };
        ret != 0
    }

    #[doc(alias = "CFNumberCompare")]
    #[inline]
    pub unsafe fn compare(
        self: &CFNumber,
        other_number: Option<&CFNumber>,
        context: *mut c_void,
    ) -> CFComparisonResult {
        extern "C-unwind" {
            fn CFNumberCompare(
                number: &CFNumber,
                other_number: Option<&CFNumber>,
                context: *mut c_void,
            ) -> CFComparisonResult;
        }
        unsafe { CFNumberCompare(self, other_number, context) }
    }
}

#[deprecated = "renamed to `CFBoolean::value`"]
#[inline]
pub extern "C-unwind" fn CFBooleanGetValue(boolean: &CFBoolean) -> bool {
    extern "C-unwind" {
        fn CFBooleanGetValue(boolean: &CFBoolean) -> Boolean;
    }
    let ret = unsafe { CFBooleanGetValue(boolean) };
    ret != 0
}

#[deprecated = "renamed to `CFNumber::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberCreate(
    allocator: Option<&CFAllocator>,
    the_type: CFNumberType,
    value_ptr: *const c_void,
) -> Option<CFRetained<CFNumber>> {
    extern "C-unwind" {
        fn CFNumberCreate(
            allocator: Option<&CFAllocator>,
            the_type: CFNumberType,
            value_ptr: *const c_void,
        ) -> Option<NonNull<CFNumber>>;
    }
    let ret = unsafe { CFNumberCreate(allocator, the_type, value_ptr) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFNumber::type`"]
#[inline]
pub extern "C-unwind" fn CFNumberGetType(number: &CFNumber) -> CFNumberType {
    extern "C-unwind" {
        fn CFNumberGetType(number: &CFNumber) -> CFNumberType;
    }
    unsafe { CFNumberGetType(number) }
}

#[deprecated = "renamed to `CFNumber::byte_size`"]
#[inline]
pub extern "C-unwind" fn CFNumberGetByteSize(number: &CFNumber) -> CFIndex {
    extern "C-unwind" {
        fn CFNumberGetByteSize(number: &CFNumber) -> CFIndex;
    }
    unsafe { CFNumberGetByteSize(number) }
}

#[deprecated = "renamed to `CFNumber::is_float_type`"]
#[inline]
pub extern "C-unwind" fn CFNumberIsFloatType(number: &CFNumber) -> bool {
    extern "C-unwind" {
        fn CFNumberIsFloatType(number: &CFNumber) -> Boolean;
    }
    let ret = unsafe { CFNumberIsFloatType(number) };
    ret != 0
}

#[deprecated = "renamed to `CFNumber::value`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberGetValue(
    number: &CFNumber,
    the_type: CFNumberType,
    value_ptr: *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn CFNumberGetValue(
            number: &CFNumber,
            the_type: CFNumberType,
            value_ptr: *mut c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFNumberGetValue(number, the_type, value_ptr) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFNumber::compare`"]
    pub fn CFNumberCompare(
        number: &CFNumber,
        other_number: Option<&CFNumber>,
        context: *mut c_void,
    ) -> CFComparisonResult;
}
